/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.suggest.client.OntologyDropdownBase;
import org.eaglei.suggest.client.SharedClassChooser;
import org.eaglei.ui.gwt.search.results.OntologyDropdown;

public class FilterPanel
extends Composite {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    HorizontalPanel filterListPanel;
    private TypePropertyFilter typeFilter;
    private EIClass currentClass = null;

    public FilterPanel() {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.typeFilter = new TypePropertyFilter();
        this.filterListPanel.add((Widget)this.typeFilter);
    }

    public void setResourceType(EIURI typeURI) {
        if (typeURI == null) {
            this.setResourceType((EIClass)null);
        } else {
            ClientModelManager.INSTANCE.getClass(typeURI, new ClientModelManager.ClassCallback(){

                public void onSuccess(EIClass result) {
                    FilterPanel.this.setResourceType(result);
                }
            });
        }
    }

    public void setResourceType(EIClass typeClass) {
        if (this.currentClass != null && this.currentClass.equals((Object)typeClass)) {
            return;
        }
        if (typeClass == null) {
            this.setVisible(false);
        } else {
            this.typeFilter.setClass(typeClass);
            this.setVisible(true);
        }
        this.currentClass = typeClass;
    }

    public void addFilters(SearchRequest request) {
        EIURI selectedURI;
        if (this.currentClass != null && (selectedURI = this.typeFilter.getSelectedType()) != null) {
            request.setBinding(new SearchRequest.TypeBinding(selectedURI));
        }
    }

    static interface Binder
    extends UiBinder<Widget, FilterPanel> {
    }

    class TypePropertyFilter
    extends PropertyFilter {
        private final SharedClassChooser<OntologyDropdown> subTypeChooser;

        TypePropertyFilter() {
            super("Type:");
            this.subTypeChooser = new SharedClassChooser((OntologyDropdownBase)new OntologyDropdown());
            this.subTypeChooser.setTextBoxStyle("formText");
            this.add((Widget)this.subTypeChooser);
        }

        private void setClass(EIClass typeClass) {
            this.subTypeChooser.setClass(typeClass, false);
        }

        private EIURI getSelectedType() {
            return this.subTypeChooser.getSelectedURI();
        }
    }

    class PropertyFilter
    extends HorizontalPanel {
        PropertyFilter(String label) {
            this.add((Widget)new Label(label));
        }
    }
}

