/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.NavBar;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;

public class ResourcesGrid
extends FlexTable {
    private static final int PAGE_SIZE = 10;
    private static final int NAV_BAR_ROW = 0;
    private static final int HEADER_ROW = 1;
    private static final int STATUS_ROW = 2;
    private static final int PROGRESS_ROW = 3;
    private static final int FIRST_RESULT_ROW = 4;
    public static final String[] RESOURCE_COLUMN_NAMES = new String[]{"Resource Name", "Type", "Location"};
    private ClientSearchResultSet currentResults;
    private NavBar navBar;
    private Label status;

    public ResourcesGrid() {
        this.setStyleName("listGrid");
        this.navBar = new NavBar(this);
        this.setWidget(0, 0, (Widget)this.navBar);
        int col = 0;
        for (String colName : RESOURCE_COLUMN_NAMES) {
            this.getCellFormatter().setStyleName(1, col, "listGridHeader");
            this.setHTML(1, col++, "<b>" + colName + "</b>");
        }
        this.status = new Label();
        this.setWidget(2, 0, (Widget)this.status);
        this.setWidget(3, 0, (Widget)new Image(ApplicationResources.INSTANCE.loading()));
    }

    public void displaySearchPending() {
        this.currentResults = null;
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        rf.setVisible(0, false);
        rf.setVisible(2, false);
        rf.setVisible(3, true);
        for (int i = this.getRowCount() - 1; i >= 4; --i) {
            this.removeRow(i);
        }
    }

    public void displaySearchResults(ClientSearchResultSet results) {
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        this.currentResults = results;
        rf.setVisible(3, false);
        int count = results.getResultSet().getTotalCount();
        int max = results.getResultSet().getStartIndex() + 10;
        if (max > count) {
            max = count;
        }
        this.navBar.update(results.getResultSet().getStartIndex(), count, max);
        rf.setVisible(0, true);
        if (results.getResultSet().getResults().size() == 0) {
            this.status.setText("No results found.");
            rf.setVisible(2, true);
        } else {
            rf.setVisible(2, false);
            int row = 4;
            for (SearchResult result : results.getResultSet().getResults()) {
                this.createInstanceRow(row++, result);
            }
        }
    }

    public void createInstanceRow(int row, SearchResult searchResult) {
        Anchor labLink;
        int col = 0;
        Anchor instanceLink = new Anchor(searchResult.getEntity().getLabel(), searchResult.getEntity().getURI().toString());
        instanceLink.setTarget("_blank");
        HTML snippit = null;
        if (searchResult.getHighlight() != null) {
            snippit = new HTML(searchResult.getHighlight());
        }
        CellPanel cp = new CellPanel();
        cp.setContent((Widget)instanceLink, (Widget)snippit);
        this.setWidget(row, col++, (Widget)cp);
        Label typeLabel = new Label(searchResult.getType().getLabel());
        Label rootTypeLabel = null;
        EIEntity rootTypeEntity = this.currentResults.getMapURIToRootEntity().get(searchResult.getType().getURI());
        if (rootTypeEntity != null) {
            rootTypeLabel = new Label(rootTypeEntity.getLabel());
        }
        cp = new CellPanel();
        cp.setContent((Widget)typeLabel, (Widget)rootTypeLabel);
        if (rootTypeLabel != null) {
            rootTypeLabel.addStyleName("rootType");
        }
        this.setWidget(row, col++, (Widget)cp);
        EIEntity lab = searchResult.getLab();
        if (lab != null) {
            labLink = new Anchor(lab.getLabel(), lab.getURI().toString());
            labLink.setTarget("_blank");
        } else {
            labLink = null;
        }
        Label instLabel = new Label(searchResult.getInstitution().getLabel());
        cp = new CellPanel();
        if (ApplicationContext.IS_INSTITUTION) {
            if (labLink != null) {
                cp.setContent((Widget)labLink, null);
            }
        } else {
            cp.setContent((Widget)instLabel, (Widget)labLink);
        }
        this.setWidget(row, col++, (Widget)cp);
    }

    void previousPage() {
        int startIndex = this.currentResults.getResultSet().getStartIndex() - 10;
        assert (startIndex >= 0) : "paged beyond the start of the result list";
        this.executeNewPageSearch(startIndex);
    }

    void nextPage() {
        int startIndex = this.currentResults.getResultSet().getStartIndex() + 10;
        assert (startIndex < this.currentResults.getResultSet().getTotalCount()) : "paged beyond the end of the result list";
        this.executeNewPageSearch(startIndex);
    }

    private void executeNewPageSearch(int startIndex) {
        SearchRequest newRequest = new SearchRequest();
        SearchRequest oldRequest = this.currentResults.getResultSet().getRequest();
        newRequest.setInstitution(oldRequest.getInstitution());
        newRequest.setTerm(oldRequest.getTerm());
        newRequest.setBinding(oldRequest.getBinding());
        newRequest.setStartIndex(startIndex);
        SearchContext.INSTANCE.search(newRequest, true);
    }

    private static class CellPanel
    extends VerticalPanel {
        CellPanel() {
            this.setStyleName("resultsTableCell");
            this.setSpacing(0);
        }

        void setContent(Widget primary, Widget secondary) {
            this.clear();
            this.add(primary);
            primary.addStyleName("primary");
            if (secondary != null) {
                this.add(secondary);
                secondary.setStyleName("secondary");
            }
        }
    }
}

