/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchBar;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.FilterPanel;
import org.eaglei.ui.gwt.search.results.ResourcesGrid;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.sidebar.LeftListPanel;

public class ResultsPage
extends Composite
implements SearchContext.SearchListener {
    private LeftListPanel listPanel;
    private VerticalPanel dataPanel;
    private FilterPanel filterPanel;
    private SearchBar searchBar;
    private ResourcesGrid resultsGrid;

    public ResultsPage() {
        HorizontalPanel outer = new HorizontalPanel();
        this.listPanel = new LeftListPanel();
        outer.add((Widget)this.listPanel);
        this.dataPanel = new VerticalPanel();
        this.dataPanel.setStyleName("dataPanel");
        outer.add((Widget)this.dataPanel);
        this.initWidget((Widget)outer);
        this.searchBar = new SearchBar(false);
        this.dataPanel.add((Widget)this.searchBar);
        this.searchBar.sizeToParent(735);
        this.filterPanel = new FilterPanel();
        this.dataPanel.add((Widget)this.filterPanel);
        this.resultsGrid = new ResourcesGrid();
        this.dataPanel.add((Widget)this.resultsGrid);
        this.searchBar.addSearchRequestListener(new SearchBar.SearchRequestListener(){

            @Override
            public void onRequest(SearchRequest request) {
                ResultsPage.this.filterPanel.addFilters(request);
                SearchContext.INSTANCE.search(request, false);
            }
        });
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.displaySearchRequest(SearchContext.INSTANCE.getCurrentRequest());
            if (SearchContext.INSTANCE.isPending()) {
                this.resultsGrid.displaySearchPending();
            } else {
                this.resultsGrid.displaySearchResults(SearchContext.INSTANCE.getCurrentResults());
            }
        }
        SearchContext.INSTANCE.addListener(this);
    }

    public void setPageParams(String params) {
        SearchRequest request = new SearchRequest(params);
        SearchContext.INSTANCE.search(request, false);
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequest(SearchRequest request, boolean isPageRequest) {
        this.displaySearchRequest(request);
        this.resultsGrid.displaySearchPending();
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        this.displaySearchRequest(results.getResultSet().getRequest());
        this.resultsGrid.displaySearchResults(results);
    }

    private void displaySearchRequest(SearchRequest request) {
        this.searchBar.setSearchRequest(request);
        EIURI typeURI = request != null && request.getBinding() != null ? request.getBinding().getType() : null;
        this.filterPanel.setResourceType(typeURI);
    }

    static interface ResultsResources
    extends ClientBundle {
        @CssResource.NotStrict
        @ClientBundle.Source(value={"results.css"})
        public CssResource css();
    }
}

