/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.security;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import org.eaglei.ui.gwt.security.Session;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemote;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemoteAsync;

public class SessionContext {
    private static final SecurityServiceRemoteAsync securityService = (SecurityServiceRemoteAsync)GWT.create(SecurityServiceRemote.class);
    public static final SessionContext INSTANCE = new SessionContext();
    private String pendingUser = null;
    private Session current = null;
    private ArrayList<SessionListener> listeners = new ArrayList();

    public static String getSessionId() {
        return INSTANCE.getSession() != null ? INSTANCE.getSession().getSessionId() : null;
    }

    private SessionContext() {
    }

    public Session getSession() {
        return this.current;
    }

    public void addListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    public String getPendingUser() {
        return this.pendingUser;
    }

    public void logIn(String user, String password) {
        this.pendingUser = user;
        securityService.logIn(user, password, new AsyncCallback<Session>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)"Invalid login.  Please check username and password.");
            }

            public void onSuccess(Session result) {
                if (result == null) {
                    Window.alert((String)"Invalid login.  Please check username and password.");
                    return;
                }
                SessionContext.this.setSession(result);
            }
        });
    }

    private void setSession(Session session) {
        if (this.pendingUser == null || !this.pendingUser.equals(session.getUserName())) {
            return;
        }
        this.pendingUser = null;
        this.current = session;
        for (SessionListener listener : this.listeners) {
            listener.onLogIn(session);
        }
    }

    public void logOut() {
        this.pendingUser = null;
        for (SessionListener listener : this.listeners) {
            listener.onLogOut();
        }
        String sessionId = this.current != null ? this.current.getSessionId() : null;
        this.current = null;
        securityService.logOut(sessionId, new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Void result) {
            }
        });
    }

    public static interface SessionListener {
        public void onLogIn(Session var1);

        public void onLogOut();
    }
}

