/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.sidebar;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.security.SessionContext;

public class LeftListPanel
extends VerticalPanel
implements SearchContext.SearchListener {
    private List<EIClass> resourceTypes;
    private final ResourceTypeTab allResourcesTab = new ResourceTypeTab(null);
    private final FlexTable resourceTabTable = new FlexTable();
    private final Map<EIURI, ResourceTypeTab> mapURIToTab = new HashMap<EIURI, ResourceTypeTab>();
    private SearchCounts currentSearchCounts = null;

    public LeftListPanel() {
        SearchContext.searchService.getTopLevelSearchCategories(new AsyncCallback<List<EIClass>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<EIClass> result) {
                LeftListPanel.this.resourceTypes = result;
                LeftListPanel.this.createPanel();
            }
        });
    }

    private void createPanel() {
        this.setWidth("100");
        this.setStyleName("leftPanel");
        this.add((Widget)this.allResourcesTab);
        this.add((Widget)this.resourceTabTable);
        this.mapURIToTab.put(null, this.allResourcesTab);
        ArrayList<EIClass> listNoDefClasses = new ArrayList<EIClass>(this.resourceTypes.size());
        for (EIClass eclass : this.resourceTypes) {
            ResourceTypeTab tab = new ResourceTypeTab(eclass);
            this.resourceTabTable.setWidget(this.resourceTabTable.getRowCount(), 0, (Widget)tab);
            this.mapURIToTab.put(eclass.getEntity().getURI(), tab);
            if (eclass.getDefinition() != null) continue;
            listNoDefClasses.add(eclass);
        }
        this.setToolTipforClass(listNoDefClasses);
        SearchContext.INSTANCE.addListener(this);
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.getSearchCounts(SearchContext.INSTANCE.getCurrentRequest());
        }
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            this.onResults(SearchContext.INSTANCE.getCurrentResults());
        }
    }

    private void executeSearch(SearchRequest.TypeBinding newBinding) {
        SearchRequest newRequest;
        SearchRequest currentRequest = SearchContext.INSTANCE.getCurrentRequest();
        if (currentRequest != null) {
            newRequest = new SearchRequest(currentRequest.getTerm());
            newRequest.setInstitution(currentRequest.getInstitution());
        } else {
            newRequest = new SearchRequest();
        }
        newRequest.setBinding(newBinding);
        SearchContext.INSTANCE.search(newRequest, false);
        this.updateSelected(newRequest.getBinding() != null ? newRequest.getBinding().getType() : null);
    }

    private void setToolTipforClass(List<EIClass> listNoDefClasses) {
        ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses, new ClientModelManager.ClassDefinitionCallback(){

            public void onSuccess(List<EIClass> result) {
                for (EIClass clazz : result) {
                    ResourceTypeTab tab = (ResourceTypeTab)((Object)LeftListPanel.this.mapURIToTab.get(clazz.getEntity().getURI()));
                    tab.setDefinition(clazz.getDefinition());
                }
            }
        });
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequest(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        this.getSearchCounts(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        if (this.currentSearchCounts != null) {
            if (!results.getResultSet().getRequest().equals((Object)this.currentSearchCounts.getRequest())) {
                return;
            }
            this.updateSearchCounts(this.currentSearchCounts, results);
        }
        this.updateSelected(results.getCategoryURI());
    }

    private void getSearchCounts(SearchRequest searchRequest) {
        this.currentSearchCounts = null;
        this.clearSearchCounts();
        if (searchRequest == null) {
            return;
        }
        final SearchCountRequest countRequest = new SearchCountRequest(searchRequest);
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                SearchContext.searchService.count(SessionContext.getSessionId(), countRequest, new AsyncCallback<SearchCounts>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(SearchCounts results) {
                        if (SearchContext.INSTANCE.getCurrentRequest() == null || !SearchContext.INSTANCE.getCurrentRequest().equals((Object)results.getRequest())) {
                            return;
                        }
                        LeftListPanel.this.currentSearchCounts = results;
                        if (SearchContext.INSTANCE.getCurrentResults() != null) {
                            LeftListPanel.this.updateSearchCounts(results, SearchContext.INSTANCE.getCurrentResults());
                        }
                    }
                });
            }
        });
    }

    private void updateSelected(EIURI selectedType) {
        if (selectedType == null) {
            this.allResourcesTab.setStyleName("panelSelected");
        } else {
            this.allResourcesTab.setStyleName("panelNotSelected");
        }
        int row = 0;
        for (EIClass t : this.resourceTypes) {
            if (t.getEntity().getURI().equals((Object)selectedType)) {
                this.resourceTabTable.getRowFormatter().setStyleName(row++, "panelSelected");
                continue;
            }
            this.resourceTabTable.getRowFormatter().setStyleName(row++, "panelNotSelected");
        }
    }

    private void clearSearchCounts() {
        this.allResourcesTab.clearCount();
        for (EIClass c : this.resourceTypes) {
            ResourceTypeTab tab = this.mapURIToTab.get(c.getEntity().getURI());
            tab.clearCount();
        }
    }

    private void updateSearchCounts(SearchCounts counts, ClientSearchResultSet resultSet) {
        assert (counts.getRequest().equals((Object)resultSet.getResultSet().getRequest()));
        for (EIURI uri : counts.getClassesForCounts()) {
            int typeCount = counts.getClassCount(uri);
            ResourceTypeTab tab = this.mapURIToTab.get(uri);
            tab.setCount(typeCount);
        }
        EIURI uri = counts.getRequest().getBinding() != null ? counts.getRequest().getBinding().getType() : null;
        int typeCount = resultSet.getResultSet().getTotalCount();
        ResourceTypeTab tab = this.mapURIToTab.get(uri);
        if (tab == null) {
            EIEntity rootTypeEntity = resultSet.getMapURIToRootEntity().get(uri);
            assert (rootTypeEntity != null) : "Search request binding type not found in result set map: " + uri;
            tab = this.mapURIToTab.get(rootTypeEntity.getURI());
        }
        tab.setCount(typeCount);
    }

    private class ResourceTypeTab
    extends FlowPanel {
        private Anchor typeLabel;
        private Label countLabel;

        ResourceTypeTab(final EIClass eiClass) {
            if (eiClass != null) {
                Label icon = new Label();
                icon.setStyleName("tempIcon");
                this.add((Widget)icon);
            }
            if (eiClass != null) {
                this.typeLabel = new Anchor(eiClass.getEntity().getLabel());
                this.typeLabel.setStyleName("gwt_super_type");
                this.setDefinition(eiClass.getDefinition());
            } else {
                this.typeLabel = new Anchor();
                this.typeLabel.setHTML("<b>All Resources</b>");
            }
            this.add((Widget)this.typeLabel);
            this.countLabel = new Label();
            this.countLabel.setStyleName("type_count");
            this.add((Widget)this.countLabel);
            this.typeLabel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (eiClass != null) {
                        LeftListPanel.this.executeSearch(new SearchRequest.TypeBinding(eiClass.getEntity().getURI()));
                    } else {
                        LeftListPanel.this.executeSearch(null);
                    }
                }
            });
        }

        void clearCount() {
            this.countLabel.setVisible(false);
        }

        void setCount(int count) {
            this.countLabel.setText("(" + count + ")");
            this.countLabel.setVisible(true);
        }

        void setDefinition(String definition) {
            this.typeLabel.setTitle(definition);
        }
    }
}

