/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.model.EIClass;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.suggest.client.OntologyDropdownBase;

public class OntologyDropdown
extends OntologyDropdownBase {
    protected void doOnClick(ClickEvent event) {
        if (this.rootClass != null && this.rootListLoading) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    if (!OntologyDropdown.this.rootListLoading) {
                        return;
                    }
                    ClientModelManager.INSTANCE.getSubClasses(OntologyDropdown.this.rootClass, new ClientModelManager.SubClassCallback(){

                        public void onSuccess(EIClass result) {
                            OntologyDropdown.this.tree.clear();
                            List subclasses = result.getSubClasses();
                            for (EIClass resource : subclasses) {
                                OntologyDropdownBase.ResourceTreeWidget w = new OntologyDropdownBase.ResourceTreeWidget((OntologyDropdownBase)OntologyDropdown.this, resource);
                                TreeItem item = OntologyDropdown.this.tree.addItem((Widget)w);
                                if (!resource.hasSubClass()) continue;
                                OntologyDropdown.this.populateChildList(item);
                                w.childListLoading = true;
                            }
                            OntologyDropdown.this.rootListLoading = false;
                            OntologyDropdown.this.setPopupHeight();
                        }
                    });
                }
            });
        }
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup.show();
            this.setPopupHeight();
        }
    }

    protected void populateChildList(final TreeItem item) {
        final OntologyDropdownBase.ResourceTreeWidget w = (OntologyDropdownBase.ResourceTreeWidget)item.getWidget();
        EIClass resource = w.getResource();
        if (resource.getSubClasses() != null) {
            this.populateChildList(item, w, resource.getSubClasses());
        } else {
            ClientModelManager.INSTANCE.getSubClasses(resource, new ClientModelManager.SubClassCallback(){

                public void onSuccess(EIClass result) {
                    if (!w.childListLoading) {
                        return;
                    }
                    OntologyDropdown.this.populateChildList(item, w, result.getSubClasses());
                }
            });
        }
    }

    protected void populateChildList(TreeItem parent, OntologyDropdownBase.ResourceTreeWidget parentWidget, List<EIClass> subclasses) {
        parent.removeItems();
        for (EIClass r : subclasses) {
            OntologyDropdownBase.ResourceTreeWidget childWidget = new OntologyDropdownBase.ResourceTreeWidget((OntologyDropdownBase)this, r);
            TreeItem child = parent.addItem((Widget)childWidget);
            if (!r.hasSubClass()) continue;
            childWidget.childListLoading = true;
        }
        parentWidget.childListLoading = false;
        this.setPopupHeight();
    }

    private void setPopupHeight() {
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                int maxHeight;
                int h = OntologyDropdown.this.tree.getOffsetHeight();
                if (h > (maxHeight = OntologyDropdown.this.computeMaxHeight())) {
                    OntologyDropdown.this.scroll.setHeight(maxHeight + "px");
                } else {
                    OntologyDropdown.this.scroll.getElement().getStyle().clearHeight();
                }
                OntologyDropdown.this.popup.showRelativeTo((UIObject)OntologyDropdown.this.p);
            }
        });
    }

    private int computeMaxHeight() {
        int top = this.p.getAbsoluteTop();
        int windowTop = Window.getScrollTop();
        int windowBottom = Window.getScrollTop() + Window.getClientHeight();
        int distanceFromWindowTop = top - windowTop;
        int distanceToWindowBottom = windowBottom - (top + this.p.getOffsetHeight());
        if (distanceToWindowBottom > 200) {
            return distanceToWindowBottom - 10;
        }
        if (distanceFromWindowTop > 200) {
            return distanceFromWindowTop - 10;
        }
        return distanceToWindowBottom > distanceFromWindowTop ? distanceToWindowBottom - 10 : distanceFromWindowTop - 10;
    }
}

