/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SearchServlet
extends RemoteServiceServlet
implements SearchServiceRemote {
    private static final Log logger = LogFactory.getLog(SearchServlet.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private SearchProvider searchProvider;
    private EIOntModel eagleiOntModel;
    private InstitutionRegistry institutionRegistry;
    private List<EIClass> searchCategoryClasses;
    private HashSet<EIURI> searchCategoryURIs;

    public void init() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.searchProvider = (SearchProvider)ctx.getBean("rootSearchProvider", SearchProvider.class);
        this.eagleiOntModel = (EIOntModel)ctx.getBean(EIOntModel.class);
        this.institutionRegistry = (InstitutionRegistry)ctx.getBean(InstitutionRegistry.class);
        List searchCategories = (List)ctx.getBean("searchCategories");
        this.searchCategoryClasses = new ArrayList<EIClass>(searchCategories.size());
        this.searchCategoryURIs = new HashSet(searchCategories.size());
        for (String uriStr : searchCategories) {
            EIURI uri = EIURI.create((String)uriStr);
            this.searchCategoryClasses.add(this.eagleiOntModel.getClass(uri));
            this.searchCategoryURIs.add(uri);
        }
        try {
            this.searchProvider.init();
            logger.info((Object)"SearchProvider created and initialized");
        }
        catch (Throwable t) {
            logger.error((Object)"Initialization of search provider failed", t);
            throw new RuntimeException("Initialization of search provider failed", t);
        }
    }

    public void destroy() {
    }

    @Override
    public List<EIEntity> getInstitutions() throws LoggedException, InvalidSessionIdException {
        try {
            return this.institutionRegistry.getInstitutions();
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getInstitutions", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public List<EIClass> getTopLevelSearchCategories() throws LoggedException {
        try {
            return this.searchCategoryClasses;
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getTopLevelSearchCategories", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public ClientSearchResultSet search(String sessionId, SearchRequest request) throws InvalidSessionIdException, LoggedException {
        if (sessionId == null) {
            throw new InvalidSessionIdException("Invalid session id.");
        }
        try {
            if (request == null) {
                logger.error((Object)"Null search request");
                throw new LoggedException();
            }
            if (DEBUG) {
                logger.debug((Object)request.toString());
            }
            SearchResultSet resultSet = this.searchProvider.query(request);
            EIURI categoryURI = null;
            if (request.getBinding() != null) {
                if (this.searchCategoryURIs.contains(request.getBinding().getType())) {
                    categoryURI = request.getBinding().getType();
                } else {
                    List superclasses = this.eagleiOntModel.getSuperClasses(request.getBinding().getType());
                    for (int i = superclasses.size() - 1; i >= 0; --i) {
                        EIURI superclassURI = ((EIClass)superclasses.get(i)).getEntity().getURI();
                        if (!this.searchCategoryURIs.contains(superclassURI)) continue;
                        categoryURI = superclassURI;
                    }
                }
            }
            HashMap<EIURI, EIEntity> mapURIToRootEntity = new HashMap<EIURI, EIEntity>();
            for (SearchResult result : resultSet.getResults()) {
                List superclasses = this.eagleiOntModel.getSuperClasses(result.getType().getURI());
                if (superclasses.size() <= 0) continue;
                mapURIToRootEntity.put(result.getType().getURI(), ((EIClass)superclasses.get(superclasses.size() - 1)).getEntity());
            }
            return new ClientSearchResultSet(resultSet, categoryURI, mapURIToRootEntity);
        }
        catch (Throwable t) {
            logger.error((Object)("Unexpected error in search: " + request.toString()), t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public SearchCounts count(String sessionId, SearchCountRequest request) throws InvalidSessionIdException, LoggedException {
        if (sessionId == null) {
            throw new InvalidSessionIdException("Invalid session id.");
        }
        try {
            if (request == null) {
                logger.error((Object)"Null search request");
                throw new LoggedException();
            }
            if (DEBUG) {
                logger.debug((Object)request.toString());
            }
            for (EIClass c : this.searchCategoryClasses) {
                EIURI uri = c.getEntity().getURI();
                if (request.getRequest().getBinding() != null && uri.equals((Object)request.getRequest().getBinding().getType())) continue;
                request.addCountType(uri);
            }
            if (request.getRequest().getBinding() != null) {
                request.addCountType(null);
            }
            return this.searchProvider.count(request);
        }
        catch (Throwable t) {
            logger.error((Object)("Unexpected error in count: " + request.toString()), t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }
}

