package org.eaglei.ui.gwt;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.home.HomePage;
import org.eaglei.ui.gwt.home.HomePageModule;
import org.eaglei.ui.gwt.search.SearchBar;
import org.eaglei.ui.gwt.search.results.ResultsPage;
import org.eaglei.ui.gwt.search.results.ResultsPageModule;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;

/**
 * This class manages a multi-page application.
 *
 */
public class ApplicationContext {

    public static final String HOME_PAGE_TOKEN = "home/";
    public static final String RESULTS_PAGE_TOKEN = "results/";
    public static final String ADVANCED_PAGE_TOKEN = "adv/";
    
    public static boolean IS_INSTITUTION;
    public static ApplicationContext INSTANCE;

    public static void setHistory(String pageToken, String pageParams) {
        assert (pageToken != null);
        StringBuilder buf = new StringBuilder(pageToken);  
        if (pageParams != null) {
            buf.append(pageParams);
        }
        History.newItem(buf.toString());
    }
    
    public static void createApplicationContext(boolean isInstitution) {
        IS_INSTITUTION = isInstitution;
        INSTANCE = new ApplicationContext();
    }
    
    private SimplePanel mainPanel;
    private HomePage homePagePanel;
    private ResultsPage resultsPagePanel;
    //private AdvancedSearch advancedSearchPanel;
    
    private String currentPage = null;
    
    private ApplicationContext() {
        ApplicationResources.INSTANCE.nineSixtyCss().ensureInjected();
        ApplicationResources.INSTANCE.clientCss().ensureInjected();
        ApplicationResources.INSTANCE.resetCss().ensureInjected();
        ApplicationResources.INSTANCE.advancedCss().ensureInjected();
        ApplicationResources.INSTANCE.globalAuxCss().ensureInjected();
        ApplicationResources.INSTANCE.globalCss().ensureInjected();
        
        // Quick Hack
    	SearchBar.HAS_INSTITUTION_SELECT = !IS_INSTITUTION;
    	
        final TopPanel topPanel = new TopPanel();
        RootPanel.get("header_container").add(topPanel);

        RootPanel mainSlot = RootPanel.get("main_container");
        if (mainSlot == null) {
            Window.alert("Missing main body element");
            return;
        }
        mainPanel = new SimplePanel();
        mainSlot.add(mainPanel);

        RootPanel footerSlot = RootPanel.get("footer_container");
        String version = footerSlot.getElement().getInnerText();
        footerSlot.getElement().setInnerText("");
        final FooterPanel footerPanel = new FooterPanel(version);
        footerSlot.add(footerPanel);

        History.addValueChangeHandler(new ValueChangeHandler<String>() {
            public void onValueChange(ValueChangeEvent<String> event) {
                String historyToken = event.getValue();
                handleHistoryChanged(historyToken);
            }
        });
        SessionContext.INSTANCE.addListener(new SessionListener() {
            
            @Override
            public void onLogOut() {
                String initToken = History.getToken();
                handleHistoryChanged(initToken);
            }
            
            @Override
            public void onLogIn() {
                String initToken = History.getToken();
                handleHistoryChanged(initToken);
            }
        });
        // Show the initial screen.
        String initToken = History.getToken();
        handleHistoryChanged(initToken);
    }
    
    public String getCurrentPage() {
        return currentPage;
    }

    private void handleHistoryChanged(String strToken) {
        if (strToken == null || strToken.length() == 0 || strToken.startsWith(HOME_PAGE_TOKEN)) {
            currentPage = HOME_PAGE_TOKEN;
            final String pageParams;
            if (strToken == null || strToken.length() == 0) {
                pageParams = null;
            } else {
                pageParams = strToken.substring(HOME_PAGE_TOKEN.length());
            }
            if (homePagePanel == null) {
                HomePageModule.createAsync(new HomePageModule.ModuleClient() {
    
                    @Override
                    public void onSuccess(HomePage instance) {
                        homePagePanel = instance;
                        mainPanel.setWidget(homePagePanel);
                        homePagePanel.setPageParams(pageParams);
                    }
    
                    @Override
                    public void onUnavailable() {
                        Window.alert("Error loading home page module.");
                    }
    
                });
            } else {
                mainPanel.setWidget(homePagePanel);
                homePagePanel.setPageParams(pageParams);
           }
        } else if (strToken.startsWith(RESULTS_PAGE_TOKEN)) {
            currentPage = RESULTS_PAGE_TOKEN;
            final String pageParams = strToken.substring(RESULTS_PAGE_TOKEN.length());
            if (resultsPagePanel == null) {
                ResultsPageModule.createAsync(new ResultsPageModule.ModuleClient() {
    
                    @Override
                    public void onSuccess(ResultsPage instance) {
                        resultsPagePanel = instance;
                        mainPanel.setWidget(resultsPagePanel);
                        resultsPagePanel.setPageParams(pageParams);
                    }
    
                    @Override
                    public void onUnavailable() {
                        Window.alert("Error loading results module.");
                    }
    
                });
            } else {
                mainPanel.setWidget(resultsPagePanel);
                resultsPagePanel.setPageParams(pageParams);
            }
        }
        /*    
        } else if (strToken.startsWith(Application.ADVANCED_PAGE_TOKEN)) {
            currentRequest = new SearchRequest(strToken.substring(Application.ADVANCED_PAGE_TOKEN.length()));
            if (advancedSearchPanel == null) {
                AdvancedSearchModule.createAsync(new AdvancedSearchModule.ModuleClient() {
    
                    @Override
                    public void onSuccess(AdvancedSearch instance) {
                        advancedSearchPanel = instance;
                        mainPanel.setWidget(advancedSearchPanel);
                        advancedSearchPanel.setSearchRequest(currentRequest);
                    }
    
                    @Override
                    public void onUnavailable() {
                        Window.alert("Error loading advanced search module.");
                    }
    
                });
            } else {
                mainPanel.setWidget(advancedSearchPanel);
                advancedSearchPanel.setSearchRequest(currentRequest);
            }
        }
        */
    }

}
