package org.eaglei.ui.gwt;



import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.security.Session;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * The top panel, header logo, sign in, etc
 */
public class TopPanel extends Composite implements SessionListener  {

    interface Binder extends UiBinder<Widget, TopPanel> {
    }

    private static final Binder binder = GWT.create(Binder.class);
    @UiField
    Label welcomeLabel;
    @UiField
    Anchor registerAnchor;
    @UiField
    UListElement loginList;
    @UiField
    TextBox userTextBox;
    @UiField
    PasswordTextBox passTextBox;
    @UiField
    Button loginButton;
    
    boolean signedIn = false;

    public static String[] wfStates;
    
    public static Map<String,Boolean> accessMap = new HashMap<String,Boolean>(); 
    
    public TopPanel() {
        initWidget(binder.createAndBindUi(this));
        passTextBox.addKeyUpHandler(new KeyUpHandler() {
            @Override
            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
                    performLogin();
                }
            }
        });

        loginButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                performLogin();
            }
        });
        
        registerAnchor.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if (signedIn) {
                   performLogout();
                }
            }
        });
        
        /*
        if (DatatoolsCookies.hasSession())
		{
			signedIn = true;
			Log.info("top panel already logged in");
		}
        */
		
        SessionContext.INSTANCE.addListener(this);
        if (SessionContext.getSessionId() != null) {
            onLogIn();
        }
    }

    private void performLogin() {
    	String user = userTextBox.getText();
        if (user == null || user.trim().length() == 0) {
            Window.alert("A username is required");
            return;
        } 
        String pass = passTextBox.getText();
        if (pass == null || pass.trim().length() == 0) {
            Window.alert("A password is required");
            return;
        }
        SessionContext.INSTANCE.logIn(user.trim(), pass.trim());
    }
    
    private void performLogout() {
        SessionContext.INSTANCE.logOut();
	}

    @Override
    public void onLogOut() {
        welcomeLabel.setText("Please login");  
        registerAnchor.setText("Register");
        loginList.getStyle().setVisibility(Style.Visibility.VISIBLE);
        signedIn = false;
        userTextBox.setText("");
        passTextBox.setText("");
    }

    @Override
    public void onLogIn() {
        welcomeLabel.setText("Welcome, "+SessionContext.getUserName());
        registerAnchor.setText("Logout");
        //userURI.setText(text);
        loginList.getStyle().setVisibility(Style.Visibility.HIDDEN);
        signedIn = true;
    }
    
}
