package org.eaglei.ui.gwt.search.results;

import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.search.SearchContext;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

public class ResultsListPanel extends Composite {

    private class ResultPanel extends VerticalPanel {
        ResultPanel(final SearchResult result) {
            setStyleName("ResultPanel");
            final String entityLabel = result.getEntity().getLabel();
            Anchor link;
            if (result.getURL() != null) {
                link = new Anchor(entityLabel, false, result.getURL());
                link.setTarget("_blank");
            } else {
                link = new Anchor(entityLabel);
            }
            /*
            link.addClickHandler(new ClickHandler() {

                @Override
                public void onClick(ClickEvent event) {
                    // TODO Auto-generated method stub

                }

            });
            */
            link.addStyleName("link");
            add(link);

            // if the type is identical to the label, don't show it
            final String typeLabel = result.getType().getLabel();
            if (!typeLabel.equals(entityLabel)) {
                Label type = new Label(typeLabel);
                type.setStyleName("type");
                add(type);
            }

            final EIEntity lab = result.getLab();
            if (lab != null) {
                final String labName = lab.getLabel();
                // if the lab label is identical to the entity label, don't show
                // it
                // (this will be the case for lab resources)
                if (!labName.equals(entityLabel)) {
                    Label labLabel = new Label(labName);
                    labLabel.setStyleName("location");
                    add(labLabel);
                }
            }

            Label institution = new Label(result.getInstitution().getLabel());
            institution.setStyleName("location");
            add(institution);

            if (result.getHighlight() != null) {
                HTML highlight = new HTML(result.getHighlight());
                highlight.setStyleName("snippit");
                add(highlight);
            }
        }
    }

    static final int VISIBLE_RESULT_COUNT = SearchRequest.DEFAULT_PAGE_SIZE;

    private VerticalPanel panelResults;
    private SearchResultSet results;
    private NavBar navBar;

    public ResultsListPanel() {
        panelResults = new VerticalPanel();
        //navBar = new NavBar(this);
        panelResults.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        panelResults.add(navBar);
        panelResults.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        initWidget(panelResults);
        setWidth("100%");
    }

    void setResultSet(SearchResultSet results) {
        if (this.results == results) {
            // TODO is this sufficient?
            return;
        }
        this.results = results;

        // Update the older/newer buttons & label.
        int count = results.getTotalCount();
        int max = results.getStartIndex() + VISIBLE_RESULT_COUNT;
        if (max > count) {
            max = count;
        }

        // Update the nav bar.
        navBar.update(results.getStartIndex(), count, max);

        // Show the current page of results
        for (int i=panelResults.getWidgetCount()-1; i>0; i--) {
            panelResults.remove(i);
        }
        for (SearchResult result : results.getResults()) {
            panelResults.add(new ResultPanel(result));
        }
    }

    void previousPage() {
        // Move back a page.
        int startIndex = results.getStartIndex() - VISIBLE_RESULT_COUNT;
        assert(startIndex >= 0) : "paged beyond the start of the result list";
        executeNewSearch(startIndex);
    }

    void nextPage() {
        // Move forward a page.
        int startIndex = results.getStartIndex() + VISIBLE_RESULT_COUNT;
        assert(startIndex < results.getTotalCount()) : "paged beyond the end of the result list";
        executeNewSearch(startIndex);
    }

    private void executeNewSearch(int startIndex) {
        SearchRequest newRequest = new SearchRequest();
        SearchRequest oldRequest = results.getRequest();
        newRequest.setInstitution(oldRequest.getInstitution());
        // Is it risky to not create a new term and binding?
        newRequest.setTerm(oldRequest.getTerm());
        newRequest.setBinding(oldRequest.getBinding());
        newRequest.setStartIndex(startIndex);
        SearchContext.INSTANCE.search(newRequest, false, true);
    }
}
