package org.eaglei.ui.gwt.security.server;

import java.util.List;

import javax.servlet.ServletException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.security.Session;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemote;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * Implementation of SearchService.
 */
public class SecurityServlet extends RemoteServiceServlet implements SecurityServiceRemote {

    private static final Log logger = LogFactory.getLog(SecurityServlet.class);
    private static final boolean DEBUG = logger.isDebugEnabled(); 
    
    public SecurityServlet() {
    }
    
    @Override
    public void init() {
        // TODO get security manager as a bean
        //WebApplicationContext ctx = 
        //    WebApplicationContextUtils.getWebApplicationContext(getServletContext());
    }

    @Override
    public void destroy() {
        //TODO does Spring need to be gracefully shutdown?
    }

    @Override
    public Session logIn(String username, String password) throws LoggedException {
        // Currently requiring data requests as well login to be https
        //SessionManager.checkHttps(getThreadLocalRequest());

        try {
            SessionManager.authenticate(username, password);
        } catch (InvalidSessionIdException e) {
            return null;
        }
        
        try {
            // Must ensure that a session is not created while the session
            // garbage collector thread is cleaning out stale sessions.
            String sessionId;
            synchronized (this) {
                sessionId = SessionManager.addSession(getThreadLocalResponse());
            }
            return new Session(username, sessionId, false);
        } catch (Throwable t) {
            logger.error("Unexpected exception", t);
            throw new LoggedException("Error during login: " + t.getLocalizedMessage());
        }
    }

    @Override
    public void logOut(String sessionId) {
        try {
            SessionManager.removeSession(sessionId);
        } catch (Throwable e) {
            logger.error("Unexpected exception", e);
        }
    }

}
