/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.results.OntologyDropdown;
import org.eaglei.ui.gwt.search.results.TypeChooser;

public class FilterPanel
extends Composite {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    HorizontalPanel filterListPanel;
    private TypePropertyFilter typeFilter;
    private EIClass currentRootClass;
    private static Map<EIURI, List<DatatypePropertyInfo>> FILTER_PROPERTY_MAP = null;

    public FilterPanel() {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.typeFilter = new TypePropertyFilter();
        this.filterListPanel.add((Widget)this.typeFilter);
    }

    public EIURI getResourceType() {
        return this.currentRootClass.getEntity().getURI();
    }

    public void setResourceType(EIURI rootTypeURI, final EIEntity selectedTypeEntity) {
        if (rootTypeURI == null) {
            this.setResourceType((EIClass)null, selectedTypeEntity);
        } else {
            ClientModelManager.INSTANCE.getClass(rootTypeURI, new ClientModelManager.ClassCallback(){

                public void onSuccess(EIClass result) {
                    FilterPanel.this.setResourceType(result, selectedTypeEntity);
                }
            });
        }
    }

    private void setResourceType(EIClass rootTypeClass, EIEntity selectedTypeEntity) {
        this.typeFilter.setClass(rootTypeClass, selectedTypeEntity);
        if (this.currentRootClass == null && rootTypeClass != null || this.currentRootClass != null && !this.currentRootClass.equals((Object)rootTypeClass)) {
            this.updateSearchFilters(rootTypeClass);
        }
        this.currentRootClass = rootTypeClass;
    }

    public void addFilters(SearchRequest request) {
        EIURI selectedURI = this.typeFilter.getSelectedType();
        SearchRequest.TypeBinding binding = null;
        if (selectedURI != null) {
            binding = new SearchRequest.TypeBinding(selectedURI);
        } else if (this.currentRootClass != null) {
            binding = new SearchRequest.TypeBinding(this.currentRootClass.getEntity().getURI());
        }
        if (binding != null) {
            for (int i = 1; i < this.filterListPanel.getWidgetCount(); ++i) {
                DatatypePropertyFilter propFilter = (DatatypePropertyFilter)this.filterListPanel.getWidget(i);
                EIURI propURI = propFilter.getPropertyURI();
                String value = propFilter.getValue();
                if (value.length() <= 0) continue;
                binding.addDataTypeProperty(propURI, value);
            }
        }
        request.setBinding(binding);
    }

    private void updateSearchFilters(EIClass rootTypeClass) {
        List<DatatypePropertyInfo> propEntityList;
        for (int i = this.filterListPanel.getWidgetCount() - 1; i > 0; --i) {
            this.filterListPanel.remove(i);
        }
        if (rootTypeClass == null) {
            return;
        }
        if (FILTER_PROPERTY_MAP == null) {
            this.initFilterMap();
        }
        if ((propEntityList = FILTER_PROPERTY_MAP.get(rootTypeClass.getEntity().getURI())) != null) {
            for (DatatypePropertyInfo pInfo : propEntityList) {
                this.filterListPanel.add((Widget)new DatatypePropertyFilter(pInfo.property.getLabel() + ":", pInfo.property.getURI(), pInfo.valueDefaultText));
            }
        }
    }

    private void initFilterMap() {
        FILTER_PROPERTY_MAP = new HashMap<EIURI, List<DatatypePropertyInfo>>();
        EIEntity locationProperty = EIEntity.create((EIURI)EIURI.create((String)"http://www.obofoundry.org/ro/ro.owl#located_in"), (String)"Lab");
        DatatypePropertyInfo locationPropertyInfo = new DatatypePropertyInfo();
        locationPropertyInfo.property = locationProperty;
        locationPropertyInfo.valueDefaultText = "Laboratory Name";
        EIEntity manufacturerProperty = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000034"), (String)"Manufacturer");
        DatatypePropertyInfo manufacturerPropertyInfo = new DatatypePropertyInfo();
        manufacturerPropertyInfo.property = manufacturerProperty;
        manufacturerPropertyInfo.valueDefaultText = "Manufacturer Name";
        EIURI type = EIURI.create((String)"http://purl.obolibrary.org/obo/OBI_0100026");
        ArrayList<DatatypePropertyInfo> propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfoList.add(locationPropertyInfo);
        DatatypePropertyInfo propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000233"), (String)"Models");
        propInfo.valueDefaultText = "Disease Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000006");
        propInfoList = new ArrayList();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000004");
        propInfoList = new ArrayList();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000005");
        propInfoList = new ArrayList();
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000015");
        propInfoList = new ArrayList();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://www.eagle-i.org/ont/data/Ctcondition"), (String)"Condition");
        propInfo.valueDefaultText = "Condition Name";
        propInfoList.add(propInfo);
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://www.eagle-i.org/ont/data/Ctintervention"), (String)"Intervention");
        propInfo.valueDefaultText = "Intervention Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000071");
        propInfoList = new ArrayList();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000070"), (String)"Lab");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
    }

    static interface Binder
    extends UiBinder<Widget, FilterPanel> {
    }

    static class TypePropertyFilter
    extends PropertyFilter {
        private final TypeChooser<OntologyDropdown> subTypeChooser = new TypeChooser<OntologyDropdown>(new OntologyDropdown());
        private EIClass currentRootClass;

        TypePropertyFilter() {
            super("Type:");
            this.subTypeChooser.setTextBoxStyle("formText");
            this.add((Widget)this.subTypeChooser);
            this.currentRootClass = null;
            this.subTypeChooser.setClass(this.currentRootClass, false);
        }

        private void setClass(EIClass rootTypeClass, EIEntity selectedTypeEntity) {
            if (this.currentRootClass == null && rootTypeClass != null || this.currentRootClass != null && !this.currentRootClass.equals((Object)rootTypeClass)) {
                this.subTypeChooser.setClass(rootTypeClass, false);
                this.currentRootClass = rootTypeClass;
            }
            if (rootTypeClass != null && selectedTypeEntity != null && rootTypeClass.getEntity().getURI().equals((Object)selectedTypeEntity.getURI())) {
                this.subTypeChooser.setSelectedEntity(null);
            } else {
                this.subTypeChooser.setSelectedEntity(selectedTypeEntity);
            }
        }

        private EIURI getSelectedType() {
            return this.subTypeChooser.getSelectedURI();
        }
    }

    static class DatatypePropertyFilter
    extends PropertyFilter {
        private EIURI propertyURI;
        private TextBox valueTextBox;
        private String defaultText;

        DatatypePropertyFilter(String label, EIURI propertyURI, final String defaultText) {
            super(label);
            this.propertyURI = propertyURI;
            this.defaultText = defaultText;
            this.valueTextBox = new TextBox();
            this.valueTextBox.setStyleName("formText");
            this.add((Widget)this.valueTextBox);
            this.valueTextBox.setText(defaultText);
            this.valueTextBox.addStyleDependentName("default");
            this.valueTextBox.addFocusHandler(new FocusHandler(){

                public void onFocus(FocusEvent event) {
                    if (defaultText.equals(DatatypePropertyFilter.this.valueTextBox.getText())) {
                        DatatypePropertyFilter.this.setText("");
                    }
                }
            });
        }

        public void setText(String text) {
            this.valueTextBox.setText(text);
            this.valueTextBox.removeStyleDependentName("default");
        }

        EIURI getPropertyURI() {
            return this.propertyURI;
        }

        String getValue() {
            String text = this.valueTextBox.getText().trim();
            if (text.equals(this.defaultText)) {
                return "";
            }
            return text;
        }
    }

    static class PropertyFilter
    extends HorizontalPanel {
        PropertyFilter(String label) {
            this.add((Widget)new Label(label));
            this.setStyleName("propertyPanel");
        }
    }

    static class DatatypePropertyInfo {
        EIEntity property;
        String valueDefaultText;

        DatatypePropertyInfo() {
        }
    }
}

