package org.eaglei.ui.gwt.search;

import java.util.ArrayList;
import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.InstitutionsCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.SuperClassesCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.TopLevelClassesCallback;
import org.eaglei.suggest.client.AbstractSearchBox.SearchHandler;
import org.eaglei.ui.gwt.home.HomePage;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ClientBundle.Source;
import com.google.gwt.resources.client.CssResource.NotStrict;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;

public class SearchBar extends Composite implements SearchContext.SearchListener {

    public interface SearchRequestListener {
    	void onRequest(SearchRequest request);
    }
    
    interface MyUiBinder extends UiBinder<Widget, SearchBar> {
    }

    private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);
    
    public static boolean HAS_INSTITUTION_SELECT;

    @UiField
    TermSuggestBox termBox;
    @UiField
    ListBox institutionListBox;
    @UiField
    ListBox typeListBox;
    @UiField
    Button searchButton;

    // Static list of top-level classes
    private List<EIClass> listTypeClasses = null;
    // Static list of institutions
    private List<EIEntity> listInstitutionEntities = null;
    private SearchRequest currentRequest = null;
    // Current list of resources displayed in the resource class list
    // Will either be the list of toplevel classes, or it will 
    // be the superclass heirarchy of some non-toplevel class.
    private List<EIClass> listCurrentTypeClasses = null;
    private SearchRequestListener listener = null;
    private boolean hasResourceSelect;
    
    public SearchBar() {
    	this(true);
    }

    public SearchBar(boolean hasResourceSelect) {
        initWidget(uiBinder.createAndBindUi(this));
        this.hasResourceSelect = hasResourceSelect;

        if (HAS_INSTITUTION_SELECT) {
            institutionListBox.setWidth("170px");
	        institutionListBox.addItem("All Institutions");
	        initInstitutionList();
        } else {
            institutionListBox.setVisible(false);
        }

        if (hasResourceSelect) {
            typeListBox.setWidth("170px");      	
	        // The first item in the resource list box will always
	        // be the All Resources label (null TypeBinding)
	        // The rest of the list will change dynamically based
	        // on the current type binding.
	        typeListBox.addItem("All Resources");
	        /*
	        resourceListBox.addChangeHandler(new ChangeHandler() {
	
	            @Override
	            public void onChange(ChangeEvent event) {
	                if (resourceListBox.getSelectedIndex() > 0) {
	                    // Constrain suggestions to 
	                    EIURI type = listResourceClasses.get(resourceListBox.getSelectedIndex() - 1).getEntity().getURI();
	                    termBox.setClassId(type);
	                } else {
	                    termBox.setClassId(null);
	                }
	            }
	            
	        });
	        */
	        //ClientModelManager.INSTANCE.getTopLevelClasses(new TopLevelClassesCallback() {
	        SearchContext.searchService.getTopLevelSearchCategories(new AsyncCallback<List<EIClass>>() {
	
	            @Override
	            public void onSuccess(List<EIClass> result) {
	                listTypeClasses = result;
	                setResource(currentRequest, null);
	            }

                @Override
                public void onFailure(Throwable caught) {
                    
                }
	
	        });
        } else {
            typeListBox.setVisible(false);
        }

    	//outer.add(searchButton);
        searchButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
            	if (listener != null) {
	                SearchRequest request = getSearchRequest();
	                listener.onRequest(request);
            	}
            }
        });

        termBox.addSearchHandler(new SearchHandler() {

            @Override
            public void performSearch(String query) {
            	if (listener != null) {
                    SearchRequest request = getSearchRequest(query);
	                listener.onRequest(request);
            	}
            }
            
        }, true, true);
        
        termBox.setDefaultText();
        
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        
        SearchContext.INSTANCE.addListener(this);
        
    }
    
    public void sizeToParent(int maxWidth) {
        int termBoxWidth = maxWidth - 95;  // search button

        if (HAS_INSTITUTION_SELECT) {
            termBoxWidth -= 180; // institution
        }

        if (hasResourceSelect) {
            termBoxWidth -= 180;  // type
        }
        
        termBox.setWidth(termBoxWidth + "px");        
    }
    
    public void addSearchRequestListener(SearchRequestListener listener) {
    	this.listener = listener;
    }
    
    public void setSearchRequest(SearchRequest request) {
        if (request != null && request.getTerm() != null) {
            termBox.setText(request.getTerm().getQuery());
        } else {
            termBox.setDefaultText();
        }
        setInstitution(request, currentRequest);
        setResource(request, currentRequest);
        currentRequest = request;
    }
    
    private void setInstitution(SearchRequest newRequest, SearchRequest oldRequest) {
    	if (institutionListBox == null) {
    		return;
    	}
    	
        // TODO check if the institution has changed to avoid traversing the
        // list if we don't have to
        if (newRequest != null && newRequest.getInstitution() != null && listInstitutionEntities != null) {
            int i = 1;
            for (EIEntity inst : listInstitutionEntities) {
                if (inst.getURI().equals(newRequest.getInstitution())) {
                    institutionListBox.setSelectedIndex(i);
                    return;
                }
                i++;
            }
        }
        institutionListBox.setSelectedIndex(0);
    }
    
    private void setResource(SearchRequest newRequest, SearchRequest oldRequest) {
    	if (typeListBox == null) {
    		return;
    	}
    	
       if (listTypeClasses == null) {
            // If we don't have the list of top-level classes yet,
            // no-op and wait for that response thread to populate
            // the list.
            return;
        }
        
        if (newRequest == null || newRequest.getBinding() == null) {
            // No type binding, display the list of top-level resources
            // select All Resources
            addTopLevelResourceList();
            typeListBox.setSelectedIndex(0);
        } else {
            final EIURI uriTypeBinding = newRequest.getBinding().getType();
            // There is a type binding, see if it is a top-level
            int indexListBox = 1; // skip All Resources index
            for (EIClass top : listTypeClasses) {
                if (top.getEntity().getURI().equals(uriTypeBinding)) {
                    addTopLevelResourceList();
                    typeListBox.setSelectedIndex(indexListBox);
                    return;
                }
                indexListBox++;
            }
            
            // Not a toplevel, compute the superclass heirarchy
            ClientModelManager.INSTANCE.getSuperClasses(uriTypeBinding, new SuperClassesCallback() {
                
                @Override
                public void onSuccess(EIClass result) {
                    addSuperClassResourceList(result);
                    typeListBox.setSelectedIndex(typeListBox.getItemCount()-1);
                }
            });
        }
    }
    
    private void addTopLevelResourceList() {
        if (listCurrentTypeClasses != listTypeClasses) {
            // Clear any previous items
            // be sure to not remove All Resources
            for (int i=typeListBox.getItemCount()-1; i>0; i--) {
                typeListBox.removeItem(i);
            }
            for (EIClass rclass : listTypeClasses) {
                typeListBox.addItem(rclass.getEntity().getLabel());
            }
            listCurrentTypeClasses = listTypeClasses;
        }
    }
    
    private void addSuperClassResourceList(EIClass rClass) {
        // Clear any previous items
        // be sure to not remove All Resources
        for (int i=typeListBox.getItemCount()-1; i>0; i--) {
            typeListBox.removeItem(i);
        }
        // Compute ancestor list
        ArrayList<EIClass> listAncestors = new ArrayList<EIClass>();
        EIClass parent = rClass.getSuperClass();
        while (parent != null) {
            listAncestors.add(parent);
            parent = parent.getSuperClass();
        }
        // Reverse the list for display order
        listCurrentTypeClasses = new ArrayList<EIClass>(listAncestors.size()+1);
        for (int i = listAncestors.size() - 1; i >= 0; i--) {
            typeListBox.addItem(listAncestors.get(i).getEntity().getLabel());
            listCurrentTypeClasses.add(listAncestors.get(i));
        }
        // The class
        typeListBox.addItem(rClass.getEntity().getLabel());
        listCurrentTypeClasses.add(rClass);
    }
    
    private SearchRequest getSearchRequest() {
        String query = termBox.getText();
        if (query != null) {
            query.trim();
        }
        
        return (getSearchRequest(query));
    }
    
    private SearchRequest getSearchRequest(String query) {
        SearchRequest request = new SearchRequest();
        
        if (query != null && query.length() > 0) {
            SearchRequest.Term term = new SearchRequest.Term(query);
            request.setTerm(term);
        }
        
        if (institutionListBox != null && institutionListBox.getSelectedIndex() > 0) {
            EIURI institution = listInstitutionEntities.get(institutionListBox.getSelectedIndex() - 1).getURI();
            request.setInstitution(institution);
        }
        
        if (typeListBox != null && typeListBox.getSelectedIndex() > 0) {
            EIURI type = listCurrentTypeClasses.get(typeListBox.getSelectedIndex() - 1).getEntity().getURI();
            SearchRequest.TypeBinding binding = new SearchRequest.TypeBinding(type);
            request.setBinding(binding);
        }
        
        return request;
    }

    private void initInstitutionList() {
        SearchServiceRemoteAsync searchService = GWT.create(SearchServiceRemote.class);
        searchService.getInstitutions(new AsyncCallback<List<EIEntity>>() {
            
            @Override
            public void onSuccess(List<EIEntity> result) {
                listInstitutionEntities = result;
                for (EIEntity institution : result) {
                    institutionListBox.addItem(institution.getLabel());
                }
                setInstitution(currentRequest, null);
            }
            
            @Override
            public void onFailure(Throwable caught) {
            }
        });
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void onRequest(SearchRequest request, boolean isTypeCategoryChange, boolean isPageRequest) {
        if (request == null) {
            return;
        }
        
        if (!isAttached()) {
            return;
        }
         
        // Write the current term box text into the SearchRequest before it is executed.
        String query = termBox.getText();
        // TODO check for URI in the SearchRequest
        if (request.getTerm() == null || request.getTerm().getQuery().length() == 0) {
            if (query.length() > 0) {
                request.setTerm(new SearchRequest.Term(query));
            }
        } else if (request.getTerm() != null && request.getTerm().getQuery().length() > 0) {
            if (!request.getTerm().getQuery().equals(query)) {
                if (query.length() > 0) {
                    request.setTerm(new SearchRequest.Term(query));
                } else {
                    request.setTerm(null);
                }
            }
        }
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        // TODO Auto-generated method stub
        
    }
}
