/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.suggest.client.AbstractSearchBox;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.TermSuggestBox;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;

public class SearchBar
extends Composite
implements SearchContext.SearchListener {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    public static boolean HAS_INSTITUTION_SELECT;
    @UiField
    TermSuggestBox termBox;
    @UiField
    ListBox institutionListBox;
    @UiField
    ListBox typeListBox;
    @UiField
    Button searchButton;
    private List<EIClass> listTypeClasses = null;
    private List<EIEntity> listInstitutionEntities = null;
    private SearchRequest currentRequest = null;
    private List<EIClass> listCurrentTypeClasses = null;
    private SearchRequestListener listener = null;
    private boolean hasResourceSelect;

    public SearchBar() {
        this(true);
    }

    public SearchBar(boolean hasResourceSelect) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.hasResourceSelect = hasResourceSelect;
        if (HAS_INSTITUTION_SELECT) {
            this.institutionListBox.setWidth("170px");
            this.institutionListBox.addItem("All Institutions");
            this.initInstitutionList();
        } else {
            this.institutionListBox.setVisible(false);
        }
        if (hasResourceSelect) {
            this.typeListBox.setWidth("170px");
            this.typeListBox.addItem("All Resources");
            SearchContext.searchService.getTopLevelSearchCategories(new AsyncCallback<List<EIClass>>(){

                public void onSuccess(List<EIClass> result) {
                    SearchBar.this.listTypeClasses = result;
                    SearchBar.this.setResource(SearchBar.this.currentRequest, null);
                }

                public void onFailure(Throwable caught) {
                }
            });
        } else {
            this.typeListBox.setVisible(false);
        }
        this.searchButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SearchBar.this.listener != null) {
                    SearchRequest request = SearchBar.this.getSearchRequest();
                    SearchBar.this.listener.onRequest(request);
                }
            }
        });
        this.termBox.addSearchHandler(new AbstractSearchBox.SearchHandler(){

            public void performSearch(String query) {
                if (SearchBar.this.listener != null) {
                    SearchRequest request = SearchBar.this.getSearchRequest(query);
                    SearchBar.this.listener.onRequest(request);
                }
            }
        }, true, true);
        this.termBox.setDefaultText();
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        SearchContext.INSTANCE.addListener(this);
    }

    public void sizeToParent(int maxWidth) {
        int termBoxWidth = maxWidth - 95;
        if (HAS_INSTITUTION_SELECT) {
            termBoxWidth -= 180;
        }
        if (this.hasResourceSelect) {
            termBoxWidth -= 180;
        }
        this.termBox.setWidth(termBoxWidth + "px");
    }

    public void addSearchRequestListener(SearchRequestListener listener) {
        this.listener = listener;
    }

    public void setSearchRequest(SearchRequest request) {
        if (request != null && request.getTerm() != null) {
            this.termBox.setText(request.getTerm().getQuery());
        } else {
            this.termBox.setDefaultText();
        }
        this.setInstitution(request, this.currentRequest);
        this.setResource(request, this.currentRequest);
        this.currentRequest = request;
    }

    private void setInstitution(SearchRequest newRequest, SearchRequest oldRequest) {
        if (this.institutionListBox == null) {
            return;
        }
        if (newRequest != null && newRequest.getInstitution() != null && this.listInstitutionEntities != null) {
            int i = 1;
            for (EIEntity inst : this.listInstitutionEntities) {
                if (inst.getURI().equals((Object)newRequest.getInstitution())) {
                    this.institutionListBox.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }
        this.institutionListBox.setSelectedIndex(0);
    }

    private void setResource(SearchRequest newRequest, SearchRequest oldRequest) {
        if (this.typeListBox == null) {
            return;
        }
        if (this.listTypeClasses == null) {
            return;
        }
        if (newRequest == null || newRequest.getBinding() == null) {
            this.addTopLevelResourceList();
            this.typeListBox.setSelectedIndex(0);
        } else {
            EIURI uriTypeBinding = newRequest.getBinding().getType();
            int indexListBox = 1;
            for (EIClass top : this.listTypeClasses) {
                if (top.getEntity().getURI().equals((Object)uriTypeBinding)) {
                    this.addTopLevelResourceList();
                    this.typeListBox.setSelectedIndex(indexListBox);
                    return;
                }
                ++indexListBox;
            }
            ClientModelManager.INSTANCE.getSuperClasses(uriTypeBinding, new ClientModelManager.SuperClassesCallback(){

                public void onSuccess(EIClass result) {
                    SearchBar.this.addSuperClassResourceList(result);
                    SearchBar.this.typeListBox.setSelectedIndex(SearchBar.this.typeListBox.getItemCount() - 1);
                }
            });
        }
    }

    private void addTopLevelResourceList() {
        if (this.listCurrentTypeClasses != this.listTypeClasses) {
            for (int i = this.typeListBox.getItemCount() - 1; i > 0; --i) {
                this.typeListBox.removeItem(i);
            }
            for (EIClass rclass : this.listTypeClasses) {
                this.typeListBox.addItem(rclass.getEntity().getLabel());
            }
            this.listCurrentTypeClasses = this.listTypeClasses;
        }
    }

    private void addSuperClassResourceList(EIClass rClass) {
        for (int i = this.typeListBox.getItemCount() - 1; i > 0; --i) {
            this.typeListBox.removeItem(i);
        }
        ArrayList<EIClass> listAncestors = new ArrayList<EIClass>();
        for (EIClass parent = rClass.getSuperClass(); parent != null; parent = parent.getSuperClass()) {
            listAncestors.add(parent);
        }
        this.listCurrentTypeClasses = new ArrayList<EIClass>(listAncestors.size() + 1);
        for (int i = listAncestors.size() - 1; i >= 0; --i) {
            this.typeListBox.addItem(((EIClass)listAncestors.get(i)).getEntity().getLabel());
            this.listCurrentTypeClasses.add((EIClass)listAncestors.get(i));
        }
        this.typeListBox.addItem(rClass.getEntity().getLabel());
        this.listCurrentTypeClasses.add(rClass);
    }

    private SearchRequest getSearchRequest() {
        String query = this.termBox.getText();
        if (query != null) {
            query.trim();
        }
        return this.getSearchRequest(query);
    }

    private SearchRequest getSearchRequest(String query) {
        SearchRequest request = new SearchRequest();
        if (query != null && query.length() > 0) {
            SearchRequest.Term term = new SearchRequest.Term(query);
            request.setTerm(term);
        }
        if (this.institutionListBox != null && this.institutionListBox.getSelectedIndex() > 0) {
            EIURI institution = this.listInstitutionEntities.get(this.institutionListBox.getSelectedIndex() - 1).getURI();
            request.setInstitution(institution);
        }
        if (this.typeListBox != null && this.typeListBox.getSelectedIndex() > 0) {
            EIURI type = this.listCurrentTypeClasses.get(this.typeListBox.getSelectedIndex() - 1).getEntity().getURI();
            SearchRequest.TypeBinding binding = new SearchRequest.TypeBinding(type);
            request.setBinding(binding);
        }
        return request;
    }

    private void initInstitutionList() {
        SearchServiceRemoteAsync searchService = (SearchServiceRemoteAsync)GWT.create(SearchServiceRemote.class);
        searchService.getInstitutions(new AsyncCallback<List<EIEntity>>(){

            public void onSuccess(List<EIEntity> result) {
                SearchBar.this.listInstitutionEntities = result;
                for (EIEntity institution : result) {
                    SearchBar.this.institutionListBox.addItem(institution.getLabel());
                }
                SearchBar.this.setInstitution(SearchBar.this.currentRequest, null);
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequest(SearchRequest request, boolean isTypeCategoryChange, boolean isPageRequest) {
        if (request == null) {
            return;
        }
        if (!this.isAttached()) {
            return;
        }
        String query = this.termBox.getText();
        if (request.getTerm() == null || request.getTerm().getQuery().length() == 0) {
            if (query.length() > 0) {
                request.setTerm(new SearchRequest.Term(query));
            }
        } else if (request.getTerm() != null && request.getTerm().getQuery().length() > 0 && !request.getTerm().getQuery().equals(query)) {
            if (query.length() > 0) {
                request.setTerm(new SearchRequest.Term(query));
            } else {
                request.setTerm(null);
            }
        }
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
    }

    static interface MyUiBinder
    extends UiBinder<Widget, SearchBar> {
    }

    public static interface SearchRequestListener {
        public void onRequest(SearchRequest var1);
    }
}

