/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.security.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;
import org.eaglei.ui.gwt.security.Session;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemote;
import org.eaglei.ui.gwt.security.server.SessionManager;

public class SecurityServlet
extends RemoteServiceServlet
implements SecurityServiceRemote {
    private static final Log logger = LogFactory.getLog(SecurityServlet.class);
    private static final boolean DEBUG = logger.isDebugEnabled();

    public void init() {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session logIn(String username, String password) throws LoggedException {
        try {
            SessionManager.authenticate(username, password);
        }
        catch (InvalidSessionIdException e) {
            return null;
        }
        try {
            String sessionId;
            SecurityServlet securityServlet = this;
            synchronized (securityServlet) {
                sessionId = SessionManager.addSession(this.getThreadLocalResponse());
            }
            return new Session(username, sessionId, false);
        }
        catch (Throwable t) {
            logger.error((Object)"Unexpected exception", t);
            throw new LoggedException("Error during login: " + t.getLocalizedMessage());
        }
    }

    @Override
    public void logOut(String sessionId) {
        try {
            SessionManager.removeSession(sessionId);
        }
        catch (Throwable e) {
            logger.error((Object)"Unexpected exception", e);
        }
    }
}

