/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.FooterPanel;
import org.eaglei.ui.gwt.TopPanel;
import org.eaglei.ui.gwt.home.HomePage;
import org.eaglei.ui.gwt.home.HomePageModule;
import org.eaglei.ui.gwt.search.SearchBar;
import org.eaglei.ui.gwt.search.results.ResultsPage;
import org.eaglei.ui.gwt.search.results.ResultsPageModule;
import org.eaglei.ui.gwt.security.SessionContext;

public class ApplicationContext {
    public static final String HOME_PAGE_TOKEN = "home/";
    public static final String RESULTS_PAGE_TOKEN = "results/";
    public static final String ADVANCED_PAGE_TOKEN = "adv/";
    public static boolean IS_INSTITUTION;
    public static String TIER;
    public static ApplicationContext INSTANCE;
    private SimplePanel mainPanel;
    private HomePage homePagePanel;
    private ResultsPage resultsPagePanel;
    private String currentPage = null;

    public static void setHistory(String pageToken, String pageParams) {
        assert (pageToken != null);
        StringBuilder buf = new StringBuilder(pageToken);
        if (pageParams != null) {
            buf.append(pageParams);
        }
        History.newItem((String)buf.toString());
    }

    public static void createApplicationContext(boolean isInstitution) {
        IS_INSTITUTION = isInstitution;
        String url = GWT.getHostPageBaseURL();
        int startIndex = url.indexOf("//");
        int endIndex = url.indexOf(".eagle-i.net");
        if (endIndex == -1 || startIndex == -1 || startIndex >= endIndex) {
            TIER = null;
        } else {
            String subdomain = url.substring(startIndex += 2, endIndex);
            if (subdomain.indexOf(46) > 0) {
                TIER = subdomain.substring(0, subdomain.indexOf(46));
            }
        }
        INSTANCE = new ApplicationContext();
    }

    private ApplicationContext() {
        ApplicationResources.INSTANCE.nineSixtyCss().ensureInjected();
        ApplicationResources.INSTANCE.clientCss().ensureInjected();
        ApplicationResources.INSTANCE.resetCss().ensureInjected();
        ApplicationResources.INSTANCE.advancedCss().ensureInjected();
        ApplicationResources.INSTANCE.globalAuxCss().ensureInjected();
        ApplicationResources.INSTANCE.globalCss().ensureInjected();
        SearchBar.HAS_INSTITUTION_SELECT = !IS_INSTITUTION;
        TopPanel.HAS_INSTITUTION_SELECT = !IS_INSTITUTION;
        TopPanel topPanel = new TopPanel();
        RootPanel.get((String)"header_container").add((Widget)topPanel);
        RootPanel mainSlot = RootPanel.get((String)"main_container");
        if (mainSlot == null) {
            Window.alert((String)"Missing main body element");
            return;
        }
        this.mainPanel = new SimplePanel();
        mainSlot.add((Widget)this.mainPanel);
        RootPanel footerSlot = RootPanel.get((String)"footer_container");
        String version = footerSlot.getElement().getInnerText();
        footerSlot.getElement().setInnerText("");
        FooterPanel footerPanel = new FooterPanel(version);
        footerSlot.add((Widget)footerPanel);
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String historyToken = (String)event.getValue();
                ApplicationContext.this.handleHistoryChanged(historyToken);
            }
        });
        SessionContext.INSTANCE.addListener(new SessionContext.SessionListener(){

            @Override
            public void onLogOut() {
                String initToken = History.getToken();
                ApplicationContext.this.handleHistoryChanged(initToken);
            }

            @Override
            public void onLogIn() {
                String initToken = History.getToken();
                ApplicationContext.this.handleHistoryChanged(initToken);
            }
        });
        String initToken = History.getToken();
        this.handleHistoryChanged(initToken);
    }

    public String getCurrentPage() {
        return this.currentPage;
    }

    private void handleHistoryChanged(String strToken) {
        if (strToken == null || strToken.length() == 0 || strToken.startsWith(HOME_PAGE_TOKEN)) {
            this.currentPage = HOME_PAGE_TOKEN;
            final String pageParams = strToken == null || strToken.length() == 0 ? null : strToken.substring(HOME_PAGE_TOKEN.length());
            if (this.homePagePanel == null) {
                HomePageModule.createAsync(new HomePageModule.ModuleClient(){

                    @Override
                    public void onSuccess(HomePage instance) {
                        ApplicationContext.this.homePagePanel = instance;
                        ApplicationContext.this.mainPanel.setWidget((Widget)ApplicationContext.this.homePagePanel);
                        ApplicationContext.this.homePagePanel.setPageParams(pageParams);
                    }

                    @Override
                    public void onUnavailable() {
                        Window.alert((String)"Error loading home page module.");
                    }
                });
            } else {
                this.mainPanel.setWidget((Widget)this.homePagePanel);
                this.homePagePanel.setPageParams(pageParams);
            }
        } else if (strToken.startsWith(RESULTS_PAGE_TOKEN)) {
            this.currentPage = RESULTS_PAGE_TOKEN;
            final String pageParams = strToken.substring(RESULTS_PAGE_TOKEN.length());
            if (this.resultsPagePanel == null) {
                ResultsPageModule.createAsync(new ResultsPageModule.ModuleClient(){

                    @Override
                    public void onSuccess(ResultsPage instance) {
                        ApplicationContext.this.resultsPagePanel = instance;
                        ApplicationContext.this.mainPanel.setWidget((Widget)ApplicationContext.this.resultsPagePanel);
                        ApplicationContext.this.resultsPagePanel.setPageParams(pageParams);
                    }

                    @Override
                    public void onUnavailable() {
                        Window.alert((String)"Error loading results module.");
                    }
                });
            } else {
                this.mainPanel.setWidget((Widget)this.resultsPagePanel);
                this.resultsPagePanel.setPageParams(pageParams);
            }
        }
    }
}

