/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.sidebar;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.security.SessionContext;

public class LeftListPanel
extends VerticalPanel
implements SearchContext.SearchListener {
    private List<EIClass> resourceTypes;
    private final Map<EIURI, ResourceTypeTab> mapURIToTab = new HashMap<EIURI, ResourceTypeTab>();
    private EIURI selectedType;
    private SearchCounts currentSearchCounts = null;

    public LeftListPanel() {
        SearchContext.searchService.getTopLevelSearchCategories(new AsyncCallback<List<EIClass>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<EIClass> result) {
                LeftListPanel.this.resourceTypes = result;
                LeftListPanel.this.createPanel();
            }
        });
    }

    private void createPanel() {
        this.setWidth("100");
        this.setStyleName("leftPanel");
        ResourceTypeTab allResourcesTab = new ResourceTypeTab(null);
        this.add((Widget)allResourcesTab);
        this.mapURIToTab.put(null, allResourcesTab);
        ArrayList<EIClass> listNoDefClasses = new ArrayList<EIClass>(this.resourceTypes.size());
        for (EIClass eclass : this.resourceTypes) {
            ResourceTypeTab tab = new ResourceTypeTab(eclass);
            this.add((Widget)tab);
            this.mapURIToTab.put(eclass.getEntity().getURI(), tab);
            if (eclass.getDefinition() != null) continue;
            listNoDefClasses.add(eclass);
        }
        this.setToolTipforClass(listNoDefClasses);
        SearchContext.INSTANCE.addListener(this);
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.getSearchCounts(SearchContext.INSTANCE.getCurrentRequest());
        }
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            this.onResults(SearchContext.INSTANCE.getCurrentResults());
        }
    }

    private void executeSearch(SearchRequest.TypeBinding newBinding) {
        SearchRequest newRequest;
        SearchRequest currentRequest = SearchContext.INSTANCE.getCurrentRequest();
        if (currentRequest != null) {
            newRequest = new SearchRequest(currentRequest.getTerm());
            newRequest.setInstitution(currentRequest.getInstitution());
        } else {
            newRequest = new SearchRequest();
        }
        newRequest.setBinding(newBinding);
        SearchContext.INSTANCE.search(newRequest);
        this.updateSelected(newRequest.getBinding() != null ? newRequest.getBinding().getType() : null);
    }

    private void setToolTipforClass(List<EIClass> listNoDefClasses) {
        ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses, new ClientModelManager.ClassDefinitionCallback(){

            public void onSuccess(List<EIClass> result) {
                for (EIClass clazz : result) {
                    ResourceTypeTab tab = (ResourceTypeTab)((Object)LeftListPanel.this.mapURIToTab.get(clazz.getEntity().getURI()));
                    tab.setDefinition(clazz.getDefinition());
                }
            }
        });
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        this.getSearchCounts(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        if (this.currentSearchCounts != null) {
            if (!results.getResultSet().getRequest().equals((Object)this.currentSearchCounts.getRequest())) {
                return;
            }
            this.updateSearchCounts(this.currentSearchCounts, results);
        }
        this.updateSelected(results.getBindingCategoryURI());
    }

    private void getSearchCounts(SearchRequest searchRequest) {
        this.currentSearchCounts = null;
        this.clearSearchCounts();
        if (searchRequest == null) {
            return;
        }
        final SearchCountRequest countRequest = new SearchCountRequest(searchRequest);
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                SearchContext.searchService.count(SessionContext.getSessionId(), countRequest, new AsyncCallback<SearchCounts>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(SearchCounts results) {
                        if (SearchContext.INSTANCE.getCurrentRequest() == null || !SearchContext.INSTANCE.getCurrentRequest().equals((Object)results.getRequest())) {
                            return;
                        }
                        LeftListPanel.this.currentSearchCounts = results;
                        if (SearchContext.INSTANCE.getCurrentResults() != null) {
                            LeftListPanel.this.updateSearchCounts(results, SearchContext.INSTANCE.getCurrentResults());
                        }
                    }
                });
            }
        });
    }

    private void updateSelected(EIURI selectedType) {
        this.selectedType = selectedType;
        for (EIURI tabURI : this.mapURIToTab.keySet()) {
            ResourceTypeTab headerTab = this.mapURIToTab.get(tabURI);
            if (tabURI == null) {
                if (selectedType == null) {
                    headerTab.setStyleName("panelSelected");
                    continue;
                }
                headerTab.setStyleName("panelNotSelected");
                continue;
            }
            if (tabURI.equals((Object)selectedType)) {
                headerTab.setStyleName("panelSelected");
                continue;
            }
            headerTab.setStyleName("panelNotSelected");
        }
    }

    private void clearSearchCounts() {
        for (ResourceTypeTab headerTab : this.mapURIToTab.values()) {
            headerTab.clearCount();
        }
    }

    private void updateSearchCounts(SearchCounts counts, ClientSearchResultSet resultSet) {
        for (EIURI uri : counts.getClassesForCounts()) {
            int typeCount = counts.getClassCount(uri);
            ResourceTypeTab tab = this.mapURIToTab.get(uri);
            tab.setCount(typeCount);
        }
        int typeCount = resultSet.getResultSet().getTotalCount();
        ResourceTypeTab tab = this.mapURIToTab.get(resultSet.getBindingCategoryURI());
        assert (tab != null) : "No tab found for binding category: " + resultSet.getBindingCategoryURI() + "  search: " + resultSet.getResultSet().getRequest();
        tab.setCount(typeCount);
    }

    private class ResourceTypeTab
    extends HorizontalPanel {
        private Anchor typeLabel;
        private Label countLabel;

        ResourceTypeTab(final EIClass eiClass) {
            this.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
            if (eiClass != null) {
                this.typeLabel = new Anchor(eiClass.getEntity().getLabel());
                this.setDefinition(eiClass.getDefinition());
            } else {
                this.typeLabel = new Anchor();
                this.typeLabel.setHTML("<b>All Resources</b>");
            }
            this.typeLabel.addStyleName("header_type_label");
            this.add((Widget)this.typeLabel);
            this.countLabel = new Label();
            this.countLabel.setStyleName("header_type_count");
            this.add((Widget)this.countLabel);
            this.setCellWidth((Widget)this.countLabel, "100%");
            this.typeLabel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (eiClass == null && LeftListPanel.this.selectedType == null || eiClass != null && eiClass.getEntity().getURI().equals((Object)LeftListPanel.this.selectedType)) {
                        return;
                    }
                    if (eiClass != null) {
                        LeftListPanel.this.executeSearch(new SearchRequest.TypeBinding(eiClass.getEntity().getURI()));
                    } else {
                        LeftListPanel.this.executeSearch(null);
                    }
                }
            });
        }

        void clearCount() {
            this.countLabel.setVisible(false);
        }

        void setCount(int count) {
            this.countLabel.setText("(" + count + ")");
            this.countLabel.setVisible(true);
        }

        void setDefinition(String definition) {
            this.typeLabel.setTitle(definition);
        }
    }
}

