package org.eaglei.ui.gwt.search.results;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.search.SearchBar;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.SearchBar.SearchRequestListener;
import org.eaglei.ui.gwt.search.SearchContext.SearchListener;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.sidebar.LeftListPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.CssResource.NotStrict;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ResultsPage extends Composite implements SearchListener {

    interface ResultsResources extends ClientBundle {
        @NotStrict
        @Source("results.css")
        CssResource css();
    }

    /*
    interface MyUiBinder extends UiBinder<SimplePanel, ResultsPage> {
    }

    private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

    @UiField
    ResultsTabPanel tabPanel;
    @UiField
    SideBar sideBar;
    */
	private LeftListPanel		listPanel;
	private VerticalPanel		dataPanel;
	private FilterPanel filterPanel;
	private SearchBar searchBar;
	private ResourcesGrid resultsGrid;

    public ResultsPage() {
    	/*
        // Inject styles.
        GWT.<ResultsResources> create(ResultsResources.class).css().ensureInjected();
        initWidget(uiBinder.createAndBindUi(this));
        DOM.getParent(tabPanel.getElement()).getStyle().setProperty("width", "100%");
        */
    	HorizontalPanel outer = new HorizontalPanel();
		listPanel = new LeftListPanel();
		outer.add(listPanel);
		dataPanel = new VerticalPanel();
		dataPanel.setStyleName("dataPanel");
		outer.add(dataPanel);
		initWidget(outer);
		
        searchBar = new SearchBar(false);
        dataPanel.add(searchBar);
        searchBar.sizeToParent(735);
        filterPanel = new FilterPanel();
        dataPanel.add(filterPanel);
        NavBar navBar = new NavBar();
        dataPanel.add(navBar);
        resultsGrid = new ResourcesGrid(navBar);
        dataPanel.add(resultsGrid);
        
        searchBar.addSearchRequestListener(new SearchRequestListener() {

            @Override
            public void onRequest(SearchRequest request) {
                filterPanel.addFilters(request);
                // On searchbar button press, assume no category change.
                // It may ultimately involve a category change, but that's ok.
                SearchContext.INSTANCE.search(request);
            }

        });
        
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            onResults(SearchContext.INSTANCE.getCurrentResults());
        } else if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            onRequestPending(SearchContext.INSTANCE.getCurrentRequest(), false);
        }
        SearchContext.INSTANCE.addListener(this);
    }
	
    /**
     * Handles parsing of params supported by the results page.
     * 
     * @param params
     */
    public void setPageParams(String params) {
        SearchContext.INSTANCE.setFromHistoryParams(params);
    }
    
    @Override
    public void onFailure(SearchRequest request, String message) {
        resultsGrid.displayStatusMessage(message);
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        // If the type category type has changed, then update filter panel controls.
        EIURI typeCategoryURI = (request != null && request.getBinding() != null) ? request.getBinding().getType() : null;
        // Display a null property value for type
        filterPanel.setResourceType(typeCategoryURI, null);
        if (request == null) {
            // Most likely a logout just occurred.
            resultsGrid.displayStatusMessage("");
        } else {
            resultsGrid.displaySearchPending();
        }
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        SearchRequest request = results.getResultSet().getRequest();
        //searchBar.setSearchRequest(request);
        filterPanel.setResourceType(results.getBindingCategoryURI(), results.getBindingEntity());
        resultsGrid.displaySearchResults(results);
    }

}
