package org.eaglei.ui.gwt.instance;

import org.eaglei.ui.gwt.LoginPanel;
import org.eaglei.ui.gwt.ApplicationContext.ApplicationPage;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public class InstancePageWrapper extends Composite implements SessionListener, ApplicationPage {

    interface MyUiBinder extends UiBinder<Widget, InstancePageWrapper> {
    }

    private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);
    
    @UiField InstancePage instancePage;
    @UiField LoginPanel loginPanel;

    public InstancePageWrapper() {
        initWidget(uiBinder.createAndBindUi(this));

        loginPanel.loginBox.addStyleName("subPageLoginBox");
        loginPanel.loginGrayOut.setStyleName("subPageLoginGrayOut");
        
        SessionContext.INSTANCE.addListener(this);
        // Initialize
        if (SessionContext.getSessionId() != null) {
            onLogIn();
        } else {
            onLogOut();
        }
    }

    @Override
    public Widget asWidget() {
         return this;
    }

    @Override
    public void setPageParams(String params) {
        instancePage.setPageParams(params);
    }

    @Override
    public void onLogIn() {
        instancePage.setVisible(true);
        loginPanel.setVisible(false);
    }

    @Override
    public void onLogOut() {
        instancePage.setVisible(false);
        loginPanel.setVisible(true);
    }
}
