package org.eaglei.ui.gwt.search;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.suggest.client.AbstractSearchBox.SearchHandler;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

public class SearchSidebarComponent extends Composite {

    VerticalPanel outerPanel = new VerticalPanel();
    private HorizontalPanel searchBarPanel = new HorizontalPanel();
    TermSuggestBox termBox;

    public SearchSidebarComponent() {
        initWidget(outerPanel);
        setStyleName("searchboxSidebarComponent");
        
        Label title = new Label("Search");
        outerPanel.add(title);
        title.setStyleName("title");
   
        outerPanel.add(searchBarPanel);

        termBox = new TermSuggestBox() {
            @Override
            public String getDefaultText() {
                //return "New Search";
                return super.getDefaultText();
            }
        };
        searchBarPanel.add(termBox);
        termBox.addStyleName("search_widget");

        termBox.addSearchHandler(new SearchHandler() {
    
            @Override
            public void performSearch(String query, String uri) {
                SearchRequest.Term term = 
                    new SearchRequest.Term(query, (uri != null ? EIURI.create(uri) : null));
                SearchRequest request = getSearchRequest();
                SearchContext.INSTANCE.search(request);
            }
            
        }, true, true);
    }
    
    @Override
    public void setWidth(String width) {
        super.setWidth(width);
        termBox.setWidth(width);
    }
    
    public void setDefaultText() {
        termBox.setDefaultText();
    }
    
    private SearchRequest getSearchRequest() {
        SearchRequest.Term term = null;
        String query = termBox.getText();
        if (query != null) {
            query.trim();
            if (query.length() > 0) {
                term = new SearchRequest.Term(query);
            }
        }
        
        SearchRequest request = new SearchRequest();
        request.setTerm(term);
        return request;
    }

}
