package org.eaglei.ui.gwt.search.results;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchRequest.DataSet;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.LogoutPanel;
import org.eaglei.ui.gwt.TopPanel;
import org.eaglei.ui.gwt.search.SearchBar;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.SearchContext.SearchListener;
import org.eaglei.ui.gwt.search.results.ResourcesGrid.CellPanel;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.sidebar.LeftListPanel;
import org.eaglei.ui.gwt.sidebar.SideBar;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.CssResource.NotStrict;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ResultsPage extends Composite implements SearchListener {

    interface ResultsResources extends ClientBundle {
        @NotStrict
        @Source("results.css")
        CssResource css();
    }
    
    private class RepositoryTab extends RadioButton {
        
        DataSet dataset;
        
        RepositoryTab(final DataSet dataset, String label, String tooltip) {
            super("RepoSelect", label);
            setStyleName("repoTab");
            this.dataset = dataset;
            setTitle(tooltip);
            addValueChangeHandler(new ValueChangeHandler<Boolean>() {
                
                @Override
                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (event.getValue()) {
                        executeSearch(dataset);
                    }
                }
            });
        }
        
        void displaySelected(boolean selected) {
            setValue(selected);
        }
    }
    
    private static final EIURI JOURNAL_URI = EIURI.create("journal");
    private static final EIURI DATE_URI = EIURI.create("date");
    private static final EIURI ORGANISM_URI = EIURI.create("organism");
    private static final EIURI AKA_URI = EIURI.create("aka");
    private static final EIURI REPOSITORY_URI = EIURI.create("repository");

    /*
    interface MyUiBinder extends UiBinder<SimplePanel, ResultsPage> {
    }

    private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

    @UiField
    ResultsTabPanel tabPanel;
    @UiField
    SideBar sideBar;
    */
    private VerticalPanel outer = new VerticalPanel();
    private FlowPanel repoTabBar = new FlowPanel();
    private HorizontalPanel mainPanel = new HorizontalPanel();
	private SideBar sidebar;
	private VerticalPanel		dataPanel;
	//private FilterPanel filterPanel;
	private SearchBar searchBar;
	private ResourcesGrid resultsGrid;
	private DataSet selectedDataset = null;
    private final Map<DataSet, RepositoryTab> mapIDToTab = new HashMap<DataSet, RepositoryTab>();

    public ResultsPage() {
    	/*
        // Inject styles.
        GWT.<ResultsResources> create(ResultsResources.class).css().ensureInjected();
        initWidget(uiBinder.createAndBindUi(this));
        DOM.getParent(tabPanel.getElement()).getStyle().setProperty("width", "100%");
        */
        
        initWidget(outer);
        outer.setStyleName("resultsPageOuter");
       
        LogoutPanel logoutPanel = new LogoutPanel();
        outer.add(logoutPanel);
        logoutPanel.setStyleName("searchPageLogoutBox");
        
        searchBar = new SearchBar(false);
        outer.add(searchBar);
        
        outer.add(repoTabBar);
        repoTabBar.addStyleName("repoTabBar");

        outer.add(mainPanel);
        
        RepositoryTab tab;
        tab = new RepositoryTab(DataSet.EI_RESOURCES, "eagle-i", "Search eagle-i for research resources");
        mapIDToTab.put(tab.dataset, tab);
        repoTabBar.add(tab);
        tab = new RepositoryTab(DataSet.NIF_RESOURCES, "NIF", "Search NIF for research resources");
        mapIDToTab.put(tab.dataset, tab);
        repoTabBar.add(tab);
        tab = new RepositoryTab(DataSet.PUBS, "PubMed", "Search for publications");
        mapIDToTab.put(tab.dataset, tab);
        repoTabBar.add(tab);
        tab = new RepositoryTab(DataSet.GENES, "Entrez Gene", "Search for genes");
        mapIDToTab.put(tab.dataset, tab);
        repoTabBar.add(tab);

        sidebar = new SideBar();
        mainPanel.add(sidebar);

		LeftListPanel listPanel = new LeftListPanel();
		sidebar.add(listPanel);
		SidebarFilterPanel filterPanel = new SidebarFilterPanel();
        sidebar.add(filterPanel);
		
		dataPanel = new VerticalPanel();
		dataPanel.setStyleName("dataPanel");
		mainPanel.add(dataPanel);
		
		/*
        filterPanel = new FilterPanel();
        dataPanel.add(filterPanel);
        */
        NavBar navBar = new NavBar();
        dataPanel.add(navBar);
        resultsGrid = new ResourcesGrid(navBar);
        dataPanel.add(resultsGrid);
    
        // eagle-i Search
        String[] resourceColumnNames = { "Resource Name", "Type", "Location" };
        ResourcesGrid.DataSetRenderer renderer = new ResourcesGrid.DataSetRenderer(resultsGrid, DataSet.EI_RESOURCES, resourceColumnNames);
        resultsGrid.addRenderer(renderer);
        
        // NIF Search
        // same col names as eagle-i
        renderer = new ResourcesGrid.DataSetRenderer(resultsGrid, DataSet.NIF_RESOURCES, resourceColumnNames) {
            public void createInstanceRow(int row, DataSet dataset, SearchResult searchResult) {
                int col = 0;
                
                // Name cell
                Widget instanceLink = new HTML(searchResult.getURL());
                HTML snippit = null;
                if (searchResult.getHighlight() != null) {
                    snippit = new HTML(searchResult.getHighlight());
                }
                CellPanel cp = new CellPanel();
                cp.setContent(instanceLink, snippit);
                resultsTable.setWidget(row, col++, cp);

                // Type cell
                Label typeLabel = new Label(searchResult.getType().getLabel());
                Label rootTypeLabel = null;
                //EIEntity rootTypeEntity = resultsTable.currentResults.getMapURIToRootEntity().get(searchResult.getType().getURI());
                //if (rootTypeEntity != null) {
                //    rootTypeLabel = new Label(rootTypeEntity.getLabel());
                //}
                cp = new CellPanel();
                cp.setContent(typeLabel, rootTypeLabel);
                if (rootTypeLabel != null) {
                    rootTypeLabel.addStyleName("rootType");
                }
                resultsTable.setWidget(row, col++, cp);
                
                // Location cell
                Set<String> repoList = searchResult.getDataTypeProperty(REPOSITORY_URI);
                for (String repo : repoList) {
                    Label repoLabel = new Label(repo);
                    cp = new CellPanel();
                    cp.setContent(repoLabel, null);
                    break;
                }
                cp.addStyleName("noWrapCell");
                resultsTable.setWidget(row, col++, cp);
            }
        };
        resultsGrid.addRenderer(renderer);
        
        // PubMed Search
        String[] pubColumnNames = { "Title", "Journal", "Date" };
        renderer = new ResourcesGrid.DataSetRenderer(resultsGrid, DataSet.PUBS, pubColumnNames) {
            public void createInstanceRow(int row, DataSet dataset, SearchResult searchResult) {
                int col = 0;
                
                // Name cell
                Widget instanceLink;
                if (dataset == DataSet.EI_RESOURCES) {
                    instanceLink = new Hyperlink(searchResult.getEntity().getLabel(), 
                            ApplicationContext.INSTANCE_PAGE_TOKEN + "uri=" + searchResult.getEntity().getURI().toString());
                } else {
                    instanceLink = new Anchor(searchResult.getEntity().getLabel(), searchResult.getEntity().getURI().toString());
                    ((Anchor) instanceLink).setTarget("_blank"); // display in new tab
                }
                HTML snippit = null;
                if (searchResult.getHighlight() != null) {
                    snippit = new HTML(searchResult.getHighlight());
                }
                CellPanel cp = new CellPanel();
                cp.setContent(instanceLink, snippit);
                resultsTable.setWidget(row, col++, cp);

                // Journal cell
                Set<String> journalList = searchResult.getDataTypeProperty(JOURNAL_URI);
                for (String journal : journalList) {
                    Label typeLabel = new Label(journal);
                    cp = new CellPanel();
                    cp.setContent(typeLabel, null);
                    break;
                }
                resultsTable.setWidget(row, col++, cp);
                
                // Date cell
                Set<String> dateList = searchResult.getDataTypeProperty(DATE_URI);
                for (String date : dateList) {
                    Label typeLabel = new Label(date);
                    cp = new CellPanel();
                    cp.setContent(typeLabel, null);
                    break;
                }
                cp.addStyleName("noWrapCell");
                resultsTable.setWidget(row, col++, cp);
            }          
        };
        resultsGrid.addRenderer(renderer);
        
        // Gene Search
        String[] geneColumnNames = { "Full Name", "Organism", "Also Known As" };
        renderer = new ResourcesGrid.DataSetRenderer(resultsGrid, DataSet.GENES, geneColumnNames) {
            public void createInstanceRow(int row, DataSet dataset, SearchResult searchResult) {
                int col = 0;
                
                // Name cell
                Widget instanceLink;
                if (dataset == DataSet.EI_RESOURCES) {
                    instanceLink = new Hyperlink(searchResult.getEntity().getLabel(), 
                            ApplicationContext.INSTANCE_PAGE_TOKEN + "uri=" + searchResult.getEntity().getURI().toString());
                } else {
                    instanceLink = new Anchor(searchResult.getEntity().getLabel(), searchResult.getEntity().getURI().toString());
                    ((Anchor) instanceLink).setTarget("_blank"); // display in new tab
                }
                HTML snippit = null;
                if (searchResult.getHighlight() != null) {
                    snippit = new HTML(searchResult.getHighlight());
                }
                CellPanel cp = new CellPanel();
                cp.setContent(instanceLink, snippit);
                resultsTable.setWidget(row, col++, cp);

                // Organism cell
                Set<String> organismList = searchResult.getDataTypeProperty(ORGANISM_URI);
                for (String organism : organismList) {
                    Label orgLabel = new Label(organism);
                    cp = new CellPanel();
                    cp.setContent(orgLabel, null);
                    break;
                }
                resultsTable.setWidget(row, col++, cp);
                
                // aka cell
                Set<String> akaList = searchResult.getDataTypeProperty(AKA_URI);
                for (String aka : akaList) {
                    Label typeLabel = new Label(aka);
                    cp = new CellPanel();
                    cp.setContent(typeLabel, null);
                    break;
                }
                resultsTable.setWidget(row, col++, cp);
            }            
        };
        resultsGrid.addRenderer(renderer);
        
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            onResults(SearchContext.INSTANCE.getCurrentResults());
        } else if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            onRequestPending(SearchContext.INSTANCE.getCurrentRequest(), false);
        }
        SearchContext.INSTANCE.addListener(this);
    }
    
    public void setHeaderPanel(TopPanel topPanel) {
    	
    }
	
    /**
     * Handles parsing of params supported by the results page.
     * 
     * @param params
     */
    public void setPageParams(String params) {
        SearchContext.INSTANCE.setFromHistoryParams(params);
    }
    
    private void executeSearch(DataSet dataset) {
        if (this.selectedDataset == dataset) {
            return;
        }
        updateSelectedRepo(dataset);
        // Make a copy of the current request if there is one.
        SearchRequest currentRequest, newRequest;
        currentRequest = SearchContext.INSTANCE.getCurrentRequest();
        if (currentRequest != null) {
            newRequest = new SearchRequest(currentRequest.getTerm());
        } else {
            newRequest = new SearchRequest();
        }
        newRequest.setDataset(dataset);
        SearchContext.INSTANCE.search(newRequest);
    }

    void updateSelectedRepo(SearchRequest.DataSet selectedDataset) {
        if (this.selectedDataset == selectedDataset) {
            return;
        }
        this.selectedDataset = selectedDataset;
        for (RepositoryTab tab : mapIDToTab.values()) {
            if (selectedDataset == null) {
                tab.displaySelected(tab.dataset == SearchRequest.DEFAULT_DATASET);
            } else {
                tab.displaySelected(tab.dataset == selectedDataset);
            }
        }
        updateLayout(selectedDataset);
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        resultsGrid.displayStatusMessage(message);
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (!isAttached()) {
            return;
        }
         
        request.setDataset(selectedDataset);
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        updateSelectedRepo(request.getDataset());
        if (request == null) {
            // Most likely a logout just occurred.
            resultsGrid.displayStatusMessage("");
        } else {
            resultsGrid.displaySearchPending();
        }
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        updateSelectedRepo(results.getResultSet().getRequest().getDataset());
        resultsGrid.displaySearchResults(results);
    }

    private void updateLayout(DataSet dataset) {
        if (dataset == SearchRequest.DataSet.EI_RESOURCES) {
            dataPanel.setWidth("635px");
            resultsGrid.setWidth("635px");
            sidebar.setVisible(true);
        } else {
            dataPanel.setWidth("830px");
            resultsGrid.setWidth("830px");
            sidebar.setVisible(false);
        }
    }
}
