package org.eaglei.ui.gwt;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.home.HomePage;
import org.eaglei.ui.gwt.home.HomePageModule;
import org.eaglei.ui.gwt.home.NewHomePage;
import org.eaglei.ui.gwt.instance.InstancePage;
import org.eaglei.ui.gwt.instance.InstancePageModule;
import org.eaglei.ui.gwt.search.SearchBar;
import org.eaglei.ui.gwt.search.results.ResultsPage;
import org.eaglei.ui.gwt.search.results.ResultsPageModule;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * This class manages a multi-page application.
 * 
 */
public class ApplicationContext {
    
    public interface ApplicationPage {
        void setPageParams(String params);
        Widget asWidget();
    }

    public static final String HOME_PAGE_TOKEN = "home/";
    public static final String RESULTS_PAGE_TOKEN = "results/";
    public static final String ADVANCED_PAGE_TOKEN = "adv/";
    public static final String INSTANCE_PAGE_TOKEN = "inst/";

    public static boolean IS_INSTITUTION;
    public static String TIER; // the current eagle-i.net tier, null for prod
    public static ApplicationContext INSTANCE;
    public static String CURRENT_PAGE_TOKEN;

    public static void setHistory(String pageToken, String pageParams) {
        assert (pageToken != null);
        StringBuilder buf = new StringBuilder(pageToken);
        if (pageParams != null) {
            buf.append(pageParams);
        }
        History.newItem(buf.toString());
    }

    public static void createApplicationContext(boolean isInstitution) {
        IS_INSTITUTION = isInstitution;
        String url = GWT.getHostPageBaseURL();
        int startIndex = url.indexOf("//");
        int endIndex = url.indexOf(".eagle-i.net");
        if (endIndex == -1 || startIndex == -1 || startIndex >= endIndex) {
            TIER = null;
        } else {
            startIndex += 2;
            String subdomain = url.substring(startIndex, endIndex);
            if (subdomain.indexOf('.') > 0) {
                // There's a tier and node segement.
                TIER = subdomain.substring(0, subdomain.indexOf('.'));
            }
        }
        INSTANCE = new ApplicationContext();
    }

    private SimplePanel mainPanel;
    private ApplicationPage homePagePanel;
    private ApplicationPage resultsPagePanel;
    private ApplicationPage instancePagePanel;
    // private AdvancedSearch advancedSearchPanel;

    private ApplicationContext() {
        ApplicationResources.INSTANCE.nineSixtyCss().ensureInjected();
        ApplicationResources.INSTANCE.clientCss().ensureInjected();
        //ApplicationResources.INSTANCE.resetCss().ensureInjected();
        ApplicationResources.INSTANCE.advancedCss().ensureInjected();
        ApplicationResources.INSTANCE.globalAuxCss().ensureInjected();
        ApplicationResources.INSTANCE.globalCss().ensureInjected();
        ApplicationResources.INSTANCE.baseCss().ensureInjected();
        ApplicationResources.INSTANCE.panelStyleCss().ensureInjected();

        // Quick Hack
        TopPanel.HAS_INSTITUTION_SELECT = !IS_INSTITUTION;
        NewHomePage.HAS_INSTITUTION_SELECT = !IS_INSTITUTION;

        RootPanel headerSlot = RootPanel.get("header_container_x");
        if (headerSlot != null) {
            //final TopPanel topPanel = new TopPanel();
            final NewTopPanel topPanel = new NewTopPanel();
            headerSlot.add(topPanel);
        } else {
            headerSlot = RootPanel.get("header_container");
            final TopPanel topPanel = new TopPanel();
            headerSlot.add(topPanel);
        }

        RootPanel mainSlot = RootPanel.get("main_container");
        if (mainSlot == null) {
            mainSlot = RootPanel.get("main_container_x");
        }
        if (mainSlot == null) {
            Window.alert("Missing main body element");
            return;
        }
        mainPanel = new SimplePanel();
        mainSlot.add(mainPanel);

        RootPanel footerSlot = RootPanel.get("footer_container_x");
        if (footerSlot != null) {
            String version = footerSlot.getElement().getInnerText();
            footerSlot.getElement().setInnerText("");
            //final FooterPanel footerPanel = new FooterPanel(version);
            final NewFooterPanel footerPanel = new NewFooterPanel(version);
            footerSlot.add(footerPanel);
        } else {
            footerSlot = RootPanel.get("footer_container");
            String version = footerSlot.getElement().getInnerText();
            footerSlot.getElement().setInnerText("");
            final FooterPanel footerPanel = new FooterPanel(version);
            footerSlot.add(footerPanel);
        }

        History.addValueChangeHandler(new ValueChangeHandler<String>() {
            public void onValueChange(ValueChangeEvent<String> event) {
                String historyToken = event.getValue();
                handleHistoryChanged(historyToken);
            }
        });
        SessionContext.INSTANCE.addListener(new SessionListener() {

            @Override
            public void onLogOut() {
                String initToken = History.getToken();
                handleHistoryChanged(initToken);
            }

            @Override
            public void onLogIn() {
                String initToken = History.getToken();
                handleHistoryChanged(initToken);
            }
        });
        // Show the initial screen.
        String initToken = History.getToken();
        handleHistoryChanged(initToken);
    }

    private void handleHistoryChanged(String strToken) {
        if (strToken == null || strToken.length() == 0 || strToken.startsWith(HOME_PAGE_TOKEN)) {
            CURRENT_PAGE_TOKEN = HOME_PAGE_TOKEN;
            final String pageParams;
            if (strToken == null || strToken.length() == 0) {
                pageParams = null;
            } else {
                pageParams = strToken.substring(HOME_PAGE_TOKEN.length());
            }
            if (homePagePanel == null) {
                HomePageModule.createAsync(new HomePageModule.ModuleClient() {

                    @Override
                    public void onSuccess(ApplicationPage instance) {
                        homePagePanel = instance;
                        mainPanel.setWidget( homePagePanel.asWidget() );
                        //homePagePanel.setPageParams(pageParams);
                    }

                    @Override
                    public void onUnavailable() {
                        Window.alert("Error loading home page module.");
                    }

                });
            } else {
                mainPanel.setWidget( homePagePanel.asWidget() );
                //homePagePanel.setPageParams(pageParams);
            }
        } else if (strToken.startsWith(RESULTS_PAGE_TOKEN)) {
            CURRENT_PAGE_TOKEN = RESULTS_PAGE_TOKEN;
            final String pageParams = strToken.substring(RESULTS_PAGE_TOKEN.length());
            if (resultsPagePanel == null) {
                ResultsPageModule.createAsync(new ResultsPageModule.ModuleClient() {

                    @Override
                    public void onSuccess(ApplicationPage instance) {
                        resultsPagePanel = instance;
                        mainPanel.setWidget( resultsPagePanel.asWidget() );
                        resultsPagePanel.setPageParams(pageParams);
                    }

                    @Override
                    public void onUnavailable() {
                        Window.alert("Error loading results module.");
                    }

                });
            } else {
                mainPanel.setWidget( resultsPagePanel.asWidget() );
                resultsPagePanel.setPageParams(pageParams);
            }
        } else if (strToken.startsWith(INSTANCE_PAGE_TOKEN)) {
            CURRENT_PAGE_TOKEN = INSTANCE_PAGE_TOKEN;
            final String pageParams = strToken.substring(INSTANCE_PAGE_TOKEN.length());
            if (instancePagePanel == null) {
                InstancePageModule.createAsync(new InstancePageModule.ModuleClient() {

                    @Override
                    public void onSuccess(ApplicationPage instance) {
                        instancePagePanel = instance;
                        mainPanel.setWidget( instancePagePanel.asWidget() );
                        instancePagePanel.setPageParams(pageParams);
                    }

                    @Override
                    public void onUnavailable() {
                        Window.alert("Error loading instance module.");
                    }

                });
            } else {
                mainPanel.setWidget( instancePagePanel.asWidget() );
                instancePagePanel.setPageParams(pageParams);
            }
        }
        /*
         * } else if (strToken.startsWith(Application.ADVANCED_PAGE_TOKEN)) {
         * currentRequest = new
         * SearchRequest(strToken.substring(Application.ADVANCED_PAGE_TOKEN
         * .length())); if (advancedSearchPanel == null) {
         * AdvancedSearchModule.createAsync(new
         * AdvancedSearchModule.ModuleClient() {
         * 
         * @Override public void onSuccess(AdvancedSearch instance) {
         * advancedSearchPanel = instance;
         * mainPanel.setWidget(advancedSearchPanel);
         * advancedSearchPanel.setSearchRequest(currentRequest); }
         * 
         * @Override public void onUnavailable() {
         * Window.alert("Error loading advanced search module."); }
         * 
         * }); } else { mainPanel.setWidget(advancedSearchPanel);
         * advancedSearchPanel.setSearchRequest(currentRequest); } }
         */
    }

}
