package org.eaglei.ui.gwt.instance;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;

public class ViewInstancePanel extends InstancePanel {
    
    private static final InstanceServiceRemoteAsync instanceService = GWT
        .create(InstanceServiceRemote.class);
    
    private Map<EIURI, String> mapTermToDefinition;

    public ViewInstancePanel(EIInstance instance, Map<EIURI, String> mapTermToDefinition) {
        super(instance);
        this.mapTermToDefinition = mapTermToDefinition;
    }
    
    @Override
    protected void initializeSpecifics() {
        // This is really fragile.  Need more explicit api.
        outerFormPanel.add(new Image(ApplicationResources.INSTANCE.loading()));
        super.initializeSpecifics();
    }
    
    @Override
    protected void finishSetup() {
        outerFormPanel.remove(0);
        super.finishSetup();
    }
    
    @Override
    protected void addNameProperty(String labelPrefix) {
        // No op because the title is being drawn elsewhere.
    }

    @Override
    protected void addTypeProperty(String labelPrefix) {
        // No op because the title is being drawn elsewhere.
    }

    @Override
    protected void drawAdminProperties() {
        // TODO Auto-generated method stub
        
    }

    @Override
    protected void drawDataProperty(EIEntity propertyEntity, String propertyDefinition,
            boolean isRequired, Set<String> propertyValues) {
        final LabelValuesWidget widget = new LabelValuesWidget( propertyEntity, propertyDefinition, isRequired );
        formPanel.add( widget );
        for (final String value : propertyValues) {
            widget.add( handleReadOnlyTextProperty( value ) );
        }
    }

    @Override
    protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
        // TODO Auto-generated method stub
        
    }

    @Override
    protected void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition,
            boolean isRequired, Set<EIEntity> propertyValues) {
        final LabelValuesWidget widget = new LabelValuesWidget( propertyEntity, propertyDefinition, isRequired );
        formPanel.add( widget );
        boolean hadValue = false;
        TreeSet<EIEntity> alphaSet = new TreeSet<EIEntity>(propertyValues);
        for (final EIEntity entity : alphaSet) {
            if ( entity == null || entity == EIEntity.NULL_ENTITY || entity.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ) {
                continue;
            }
            hadValue = true;
            String termDefinition = 
            	mapTermToDefinition != null ? mapTermToDefinition.get(entity.getURI()) : null;
            if (termDefinition == null) {
	            Hyperlink instanceLink = new Hyperlink(InstanceWidgetUtils.formatText( entity.getLabel() ), 
	                    ApplicationContext.INSTANCE_PAGE_TOKEN + "uri=" +  entity.getURI().toString());
	            widget.add( instanceLink );
            } else {
            	// Term values
    			final Label valueField = new Label( entity.getLabel() );
    			valueField.setStyleName("formLabelValue");
    			widget.add(valueField);
    			valueField.setTitle(termDefinition);
            }
        }

        if ( !hadValue ) {
            formPanel.remove( widget );
        }

    }

    @Override
    protected void drawReferencedBy() {
        // TODO Auto-generated method stub
        
    }

    @Override
    protected Collection<EIEntity> getDataTypeEntities() {
        return eiInstance.getDatatypeProperties().keySet();
    }

    @Override
    protected Collection<EIEntity> getNonOntologyLiteralPropEntities() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    protected Collection<EIEntity> getNonOntologyResourcePropEntities() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    protected Collection<EIEntity> getObjectTypeEntities() {
        return eiInstance.getObjectProperties().keySet();
    }

}
