package org.eaglei.ui.gwt.security.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.security.SecurityProvider;
import org.eaglei.security.Session;
import org.eaglei.ui.gwt.rpc.LoggedException;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemote;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * Implementation of SearchService.
 */
public class SecurityServlet extends RemoteServiceServlet implements SecurityServiceRemote {

    private static final Log logger = LogFactory.getLog(SecurityServlet.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    
    private SecurityProvider securityProvider;

    public SecurityServlet() {
    }

    @Override
    public void init() {
        WebApplicationContext ctx = 
            WebApplicationContextUtils.getWebApplicationContext(getServletContext());
        securityProvider = ctx.getBean("securityProvider", SecurityProvider.class);
    }

    @Override
    public void destroy() {
        // TODO does Spring need to be gracefully shutdown?
    }

    @Override
    public Session logIn(String institutionId, String username, String password) throws LoggedException {
        try {
            
            return securityProvider.logIn(institutionId, username, password);
           
        } catch (Throwable t) {
            logger.error("Error in login", t);
            throw new LoggedException(t.getLocalizedMessage());
        }        
    }

    @Override
    public void logOut(String sessionId) {
        try {
            
            securityProvider.logOut(sessionId);
           
        } catch (Throwable t) {
            logger.error("Error in logout", t);
        }        
    }
    
    @Override
    public Session getSession(String sessionId) {
        try {
            
            return securityProvider.getSession(sessionId);
           
        } catch (Throwable t) {
            logger.error("Error in getSession", t);
            return null;        
        }
    }

}
