/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceX;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.LogoutPanel;
import org.eaglei.ui.gwt.instance.ContactSidebarComponent;
import org.eaglei.ui.gwt.instance.ReferencedBySidebarComponent;
import org.eaglei.ui.gwt.instance.ViewInstancePanel;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.SearchSidebarComponent;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.sidebar.SideBar;

public class InstancePage
extends Composite
implements SessionContext.SessionListener,
ApplicationContext.ApplicationPage {
    private static final String URI_KEY = "uri";
    public static final InstanceServiceRemoteAsync instanceService = (InstanceServiceRemoteAsync)GWT.create(InstanceServiceRemote.class);
    private VerticalPanel instancePanel;
    private SearchSidebarComponent searchbox;
    private ContactSidebarComponent contact;
    private ReferencedBySidebarComponent references;
    private EIURI instanceID;

    public InstancePage() {
        VerticalPanel outer = new VerticalPanel();
        this.initWidget((Widget)outer);
        LogoutPanel logoutPanel = new LogoutPanel();
        outer.add((Widget)logoutPanel);
        logoutPanel.setStyleName("searchPageLogoutBox");
        HorizontalPanel mainPanel = new HorizontalPanel();
        SideBar sidebar = new SideBar();
        mainPanel.add((Widget)sidebar);
        DOM.setStyleAttribute((Element)DOM.getParent((Element)sidebar.getElement()), (String)"borderRight", (String)"1px solid #CCC");
        this.instancePanel = new VerticalPanel();
        this.instancePanel.setStyleName("instanceMainPanel");
        mainPanel.add((Widget)this.instancePanel);
        outer.add((Widget)mainPanel);
        this.contact = new ContactSidebarComponent();
        sidebar.addComponent((Widget)this.contact);
        this.references = new ReferencedBySidebarComponent();
        sidebar.addComponent((Widget)this.references);
        this.searchbox = new SearchSidebarComponent();
        sidebar.addComponent((Widget)this.searchbox);
        this.searchbox.setWidth("180px");
        this.contact.setWidth("180px");
        this.references.setWidth("180px");
    }

    @Override
    public Widget asWidget() {
        return this;
    }

    @Override
    public void setPageParams(String params) {
        this.searchbox.setDefaultText();
        this.references.setReferences(null);
        String[] parts = params.split("=");
        if (parts.length != 2) {
            this.instancePanel.clear();
            this.instancePanel.add((Widget)new Label("Invalid URL, cannot display resource."));
        }
        if (!parts[0].equals(URI_KEY)) {
            this.instancePanel.clear();
            this.instancePanel.add((Widget)new Label("Invalid URL, cannot display resource."));
        }
        String uriStr = parts[1];
        this.instanceID = EIURI.create((String)uriStr);
        if (SessionContext.getSessionId() == null) {
            this.onLogOut();
            return;
        }
        this.displayContent();
    }

    private void displayContent() {
        this.instancePanel.clear();
        this.instancePanel.add((Widget)new Image(ApplicationResources.INSTANCE.loading()));
        instanceService.getInstance(SessionContext.getSessionId(), this.instanceID, new AsyncCallback<EIInstanceX>(){

            public void onFailure(Throwable caught) {
                InstancePage.this.instancePanel.clear();
                if (caught instanceof InvalidSessionIdException) {
                    SessionContext.INSTANCE.logOut();
                } else {
                    InstancePage.this.instancePanel.add((Widget)new HTML(caught.getLocalizedMessage()));
                }
            }

            public void onSuccess(EIInstanceX result) {
                if (!result.instance.getInstanceURI().equals((Object)InstancePage.this.instanceID)) {
                    return;
                }
                InstancePage.this.instancePanel.clear();
                EIInstance instance = result.instance;
                Label instanceTitle = new Label(instance.getInstanceLabel());
                InstancePage.this.instancePanel.add((Widget)instanceTitle);
                instanceTitle.setStyleName("instanceTitle");
                Label instanceType = new Label(instance.getInstanceType().getLabel());
                InstancePage.this.instancePanel.add((Widget)instanceType);
                instanceType.setStyleName("instanceType");
                ViewInstancePanel propertiesPanel = new ViewInstancePanel(instance, result.mapTermToDefinition);
                InstancePage.this.instancePanel.add((Widget)propertiesPanel);
                InstancePage.this.references.setReferences(result.references);
                InstancePage.this.contact.setInstance(instance);
            }
        });
    }

    @Override
    public void onLogIn() {
        if (this.instanceID != null) {
            this.displayContent();
        }
    }

    @Override
    public void onLogOut() {
        this.instancePanel.clear();
        this.references.setReferences(null);
        this.instancePanel.add((Widget)new Label("Please login"));
    }
}

