/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

public abstract class InstancePanel
extends Composite {
    protected final VerticalPanel outerFormPanel = new VerticalPanel();
    protected VerticalPanel formPanel = new VerticalPanel();
    protected EIInstance eiInstance;
    protected EIClass eiClass;
    protected EIClass rootSuperClass;
    protected List<EIProperty> eiProperties;
    protected boolean shouldShowReadOnlyProperties;

    protected abstract void drawDataProperty(EIEntity var1, String var2, boolean var3, Set<String> var4);

    protected abstract void drawObjectProperty(EIEntity var1, String var2, boolean var3, Set<EIEntity> var4);

    protected abstract void drawAdminProperties();

    protected abstract void drawReferencedBy();

    protected abstract void drawExtraFields(Map<EIEntity, Set<String>> var1);

    protected abstract Collection<EIEntity> getDataTypeEntities();

    protected abstract Collection<EIEntity> getObjectTypeEntities();

    protected abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();

    protected abstract Collection<EIEntity> getNonOntologyResourcePropEntities();

    public InstancePanel(EIInstance instance) {
        this.eiInstance = instance;
        this.initWidget((Widget)this.outerFormPanel);
        this.outerFormPanel.setStyleName("formPanel");
        this.formPanel.setStyleName("formPanel");
        this.initializeSpecifics();
    }

    protected InstancePanel() {
        this.initWidget((Widget)this.outerFormPanel);
        this.outerFormPanel.setStyleName("formPanel");
        this.formPanel.setStyleName("formPanel");
    }

    protected void initializeSpecifics() {
        this.eiClass = this.eiInstance.getInstanceClass();
        this.initializeProperties();
        this.outerFormPanel.add((Widget)this.formPanel);
    }

    protected void finishSetup() {
        this.constructForm();
        this.formPanel.setStyleName("formPanel");
        this.formPanel.setHeight("50");
    }

    public EIInstance getInstance() {
        return this.eiInstance;
    }

    protected void addNameProperty(String labelPrefix) {
        EIEntity namePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDFS_LABEL_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel(labelPrefix, EagleIEntityConstants.RDFS_LABEL_ENTITY.getLabel()));
        this.drawDataProperty(namePropEntity, "", true, this.makeSetFromSingle(this.eiInstance.getInstanceLabel()));
    }

    protected void addTypeProperty(String labelPrefix) {
        EIEntity typePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDF_TYPE_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel(labelPrefix, EagleIEntityConstants.RDF_TYPE_ENTITY.getLabel()));
        this.drawObjectProperty(typePropEntity, "", true, this.makeSetFromSingleEntity(this.eiInstance.getInstanceType()));
    }

    protected void constructForm() {
        Map instanceDataTypeProperties = this.eiInstance.getDatatypeProperties();
        Map instanceObjectProperties = this.eiInstance.getObjectProperties();
        Map instanceNonOntologyLiteralProperties = this.eiInstance.getNonOntologyLiteralProperties();
        String labelPrefix = InstanceWidgetUtils.isLabProperty(this.eiClass) ? "Laboratory" : this.rootSuperClass.getEntity().getLabel();
        this.addNameProperty(labelPrefix);
        this.addTypeProperty(labelPrefix);
        Collection<EIEntity> dataProps = this.getDataTypeEntities();
        Collection<EIEntity> objectProps = this.getObjectTypeEntities();
        for (EIProperty property : this.eiProperties) {
            if (property instanceof EIDatatypeProperty && dataProps.contains(property.getEntity())) {
                this.drawDataProperty(property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, (Set)instanceDataTypeProperties.get(property.getEntity()));
                continue;
            }
            if (!(property instanceof EIObjectProperty) || !objectProps.contains(property.getEntity())) continue;
            this.drawObjectProperty(property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, (Set)instanceObjectProperties.get(property.getEntity()));
        }
        this.drawExtraFields(instanceNonOntologyLiteralProperties);
        this.drawReferencedBy();
        this.drawAdminProperties();
    }

    protected HashSet<String> makeSetFromSingle(String value) {
        return new HashSet<String>(Arrays.asList(value));
    }

    protected HashSet<EIURI> makeSetFromSingleURI(EIURI value) {
        return new HashSet<EIURI>(Arrays.asList(value));
    }

    protected HashSet<EIEntity> makeSetFromSingleEntity(EIEntity value) {
        return new HashSet<EIEntity>(Arrays.asList(value));
    }

    protected Widget handleReadOnlyTextProperty(String value) {
        if (value.startsWith("www") || value.startsWith("http")) {
            return new Anchor(InstanceWidgetUtils.formatText(value), InstanceWidgetUtils.formatText(value), "_blank");
        }
        HTML valueField = new HTML(InstanceWidgetUtils.formatText(InstanceWidgetUtils.insertBreaks(value)));
        valueField.setStyleName("formLabelValue");
        return valueField;
    }

    protected void drawReadOnlyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    protected void drawReadOnlyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (EIEntity propEntity : propertyValues) {
            if (propEntity == null || propEntity == EIEntity.NULL_ENTITY) continue;
            widget.add(this.handleReadOnlyTextProperty(propEntity.getLabel()));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    protected void initializeProperties() {
        ClientModelManager.INSTANCE.getProperties(this.eiClass, new ClientModelManager.PropertyCallback(){

            public void onSuccess(EIClass result) {
                ClientModelManager.INSTANCE.getPropertyDefinitions(result.getProperties(), new ClientModelManager.PropertyDefinitionCallback(){

                    public void onSuccess(List<EIProperty> properties) {
                        InstancePanel.this.eiProperties = properties;
                        InstancePanel.this.getRootSuperClass();
                    }
                });
            }
        });
    }

    protected void getRootSuperClass() {
        try {
            ClientModelManager.INSTANCE.getRootSuperClass(this.eiClass, new ClientModelManager.ClassCallback(){

                public void onSuccess(EIClass result) {
                    InstancePanel.this.rootSuperClass = result;
                    InstancePanel.this.finishSetup();
                }
            });
        }
        catch (LoggedException loggedException) {
            // empty catch block
        }
    }
}

