/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIInstanceX;
import org.eaglei.model.EIURI;
import org.eaglei.security.SecurityProvider;
import org.eaglei.services.repository.RepositoryInstanceProvider;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class InstanceServlet
extends RemoteServiceServlet
implements InstanceServiceRemote {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(InstanceServlet.class);
    private RepositoryInstanceProvider instanceProvider;
    private SecurityProvider securityProvider;

    public void init() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.instanceProvider = (RepositoryInstanceProvider)ctx.getBean(RepositoryInstanceProvider.class);
        this.securityProvider = (SecurityProvider)ctx.getBean("securityProvider", SecurityProvider.class);
    }

    public void destroy() {
    }

    @Override
    public EIInstanceX getInstance(String sessionID, EIURI instanceID) throws InvalidSessionIdException, LoggedException {
        if (!this.securityProvider.isValid(sessionID)) {
            throw new InvalidSessionIdException();
        }
        try {
            return this.instanceProvider.getInstance(sessionID, instanceID);
        }
        catch (Throwable t) {
            logger.error((Object)"Error getting instance", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public boolean contactMessage(String sessionID, EIURI instanceID, String label, boolean test_mode, String from_name, String from_email, String subject, String message) throws InvalidSessionIdException, LoggedException {
        if (!this.securityProvider.isValid(sessionID)) {
            throw new InvalidSessionIdException();
        }
        try {
            String client_ip = this.getThreadLocalRequest().getLocalAddr();
            return this.instanceProvider.contactMessage(sessionID, client_ip, instanceID, label, test_mode, from_name, from_email, subject, message);
        }
        catch (Throwable t) {
            logger.error((Object)"Error sending contact message", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }
}

