/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance.widgets;

import com.google.gwt.user.client.ui.Label;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;

public class InstanceWidgetUtils {
    public static Label createLabel(EIEntity propertyEntity, String definition, boolean isRequired) {
        if (propertyEntity == null || propertyEntity == EIEntity.NULL_ENTITY) {
            return InstanceWidgetUtils.createLabel("", definition, isRequired);
        }
        if (EagleIEntityConstants.missingTooltips.containsKey(propertyEntity)) {
            return InstanceWidgetUtils.createLabel(propertyEntity.getLabel(), EagleIEntityConstants.missingTooltips.get(propertyEntity), isRequired);
        }
        return InstanceWidgetUtils.createLabel(propertyEntity.getLabel(), definition, isRequired);
    }

    public static Label createLabel(String label, String definition, boolean isRequired) {
        Label propertyLabel = label == null || "".equals(label) ? new Label(label) : new Label(InstanceWidgetUtils.capitalizeFirst(label));
        if (isRequired) {
            propertyLabel.setStyleName("formLabelRequired");
        } else {
            propertyLabel.setStyleName("formLabel");
        }
        if (definition != null && !"".equals(definition) && !"NO DEFINITION".equals(definition)) {
            propertyLabel.setTitle(definition);
        }
        return propertyLabel;
    }

    public static String capitalizeFirst(String original) {
        char first = original.charAt(0);
        return Character.toUpperCase(first) + original.substring(1);
    }

    public static String formatText(String value) {
        if (value.indexOf("^") > 0) {
            return value.substring(0, value.indexOf("^"));
        }
        return value;
    }

    public static boolean isLabProperty(EIEntity range) {
        if (range == null || range == EIEntity.NULL_ENTITY) {
            return false;
        }
        return range.getURI().toString().equals("http://purl.obolibrary.org/obo/ERO_0000001") || range.getURI().toString().equals("http://purl.obolibrary.org/obo/ERO_0000002");
    }

    public static boolean isLabProperty(EIClass range) {
        if (range == null || range.getEntity() == null) {
            return false;
        }
        return InstanceWidgetUtils.isLabProperty(range.getEntity());
    }

    public static String getExtendedPropertyLabel(String typeLabel, String propertyName) {
        return InstanceWidgetUtils.capitalizeFirst(typeLabel) + " " + propertyName;
    }

    public static String insertBreaks(String value) {
        return value.replaceAll("(\r\n|\r|\n|\n\r)", "<br/>");
    }
}

