/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.sidebar;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.OntologyDropdown;
import org.eaglei.ui.gwt.search.results.TypeChooser;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.security.SessionContext;

public class ResourceTabSidebarComponent
extends VerticalPanel
implements SearchContext.SearchListener {
    private List<EIClass> resourceTypes;
    private final Map<EIURI, AbstractTabPanel> mapURIToTab = new HashMap<EIURI, AbstractTabPanel>();
    private EIURI selectedType;
    private SearchCounts currentSearchCounts = null;
    private static Map<EIURI, List<DatatypePropertyInfo>> FILTER_PROPERTY_MAP = null;

    public ResourceTabSidebarComponent() {
        SearchContext.searchService.getTopLevelSearchCategories(new AsyncCallback<List<EIClass>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<EIClass> result) {
                ResourceTabSidebarComponent.this.resourceTypes = result;
                ResourceTabSidebarComponent.this.createPanel();
            }
        });
    }

    private void createPanel() {
        this.setWidth("100");
        this.setStyleName("leftPanel");
        AllResourcesTab allResourcesTab = new AllResourcesTab();
        this.add((Widget)allResourcesTab);
        this.mapURIToTab.put(null, allResourcesTab);
        ArrayList<EIClass> listNoDefClasses = new ArrayList<EIClass>(this.resourceTypes.size());
        for (EIClass eclass : this.resourceTypes) {
            ResourceTab tab = new ResourceTab(eclass);
            this.add((Widget)tab);
            this.mapURIToTab.put(eclass.getEntity().getURI(), tab);
            if (eclass.getDefinition() != null) continue;
            listNoDefClasses.add(eclass);
        }
        this.setToolTipforClass(listNoDefClasses);
        SearchContext.INSTANCE.addListener(this);
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.getSearchCounts(SearchContext.INSTANCE.getCurrentRequest());
        }
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            this.onResults(SearchContext.INSTANCE.getCurrentResults());
        }
    }

    private void executeSearch(SearchRequest.TypeBinding newBinding) {
        SearchRequest newRequest;
        SearchRequest currentRequest = SearchContext.INSTANCE.getCurrentRequest();
        if (currentRequest != null) {
            newRequest = new SearchRequest(currentRequest.getTerm());
            newRequest.setInstitution(currentRequest.getInstitution());
        } else {
            newRequest = new SearchRequest();
        }
        newRequest.setBinding(newBinding);
        SearchContext.INSTANCE.search(newRequest);
        this.updateSelected(newRequest.getBinding() != null ? newRequest.getBinding().getType() : null);
    }

    private void setToolTipforClass(List<EIClass> listNoDefClasses) {
        ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses, new ClientModelManager.ClassDefinitionCallback(){

            public void onSuccess(List<EIClass> result) {
                for (EIClass clazz : result) {
                    AbstractTabPanel tab = (AbstractTabPanel)((Object)ResourceTabSidebarComponent.this.mapURIToTab.get(clazz.getEntity().getURI()));
                    tab.setDefinition(clazz.getDefinition());
                }
            }
        });
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        this.getSearchCounts(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        EIURI tabURI;
        if (this.currentSearchCounts != null) {
            if (!results.getResultSet().getRequest().equals((Object)this.currentSearchCounts.getRequest())) {
                return;
            }
            this.updateSearchCounts(this.currentSearchCounts, results);
        }
        EIURI eIURI = tabURI = results.getResultSet().getRequest().getBinding() != null ? results.getResultSet().getRequest().getBinding().getType() : null;
        if (this.mapURIToTab.get(tabURI) == null) {
            tabURI = results.getBindingCategoryURI();
        }
        this.updateSelected(tabURI);
    }

    private void getSearchCounts(SearchRequest searchRequest) {
        this.currentSearchCounts = null;
        this.clearSearchCounts();
        if (searchRequest == null) {
            return;
        }
        final SearchCountRequest countRequest = new SearchCountRequest(searchRequest);
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                SearchContext.searchService.count(SessionContext.getSessionId(), countRequest, new AsyncCallback<SearchCounts>(){

                    public void onFailure(Throwable caught) {
                        if (caught instanceof InvalidSessionIdException) {
                            SessionContext.INSTANCE.logOut();
                            return;
                        }
                    }

                    public void onSuccess(SearchCounts results) {
                        if (SearchContext.INSTANCE.getCurrentRequest() == null || !SearchContext.INSTANCE.getCurrentRequest().equals((Object)results.getRequest())) {
                            return;
                        }
                        ResourceTabSidebarComponent.this.currentSearchCounts = results;
                        if (SearchContext.INSTANCE.getCurrentResults() != null) {
                            ResourceTabSidebarComponent.this.updateSearchCounts(results, SearchContext.INSTANCE.getCurrentResults());
                        }
                    }
                });
            }
        });
    }

    private void updateSelected(EIURI selectedType) {
        this.selectedType = selectedType;
        for (EIURI tabURI : this.mapURIToTab.keySet()) {
            AbstractTabPanel tab = this.mapURIToTab.get(tabURI);
            if (tabURI == null) {
                tab.setSelected(selectedType == null);
                continue;
            }
            tab.setSelected(tabURI.equals((Object)selectedType));
        }
    }

    private void clearSearchCounts() {
        for (AbstractTabPanel headerTab : this.mapURIToTab.values()) {
            headerTab.clearCount();
        }
    }

    private void updateSearchCounts(SearchCounts counts, ClientSearchResultSet resultSet) {
        for (EIURI uri : counts.getClassesForCounts()) {
            int typeCount = counts.getClassCount(uri);
            AbstractTabPanel tab = this.mapURIToTab.get(uri);
            tab.setCount(typeCount);
        }
        int typeCount = resultSet.getResultSet().getTotalCount();
        AbstractTabPanel tab = null;
        if (resultSet.getResultSet().getRequest().getBinding() != null) {
            tab = this.mapURIToTab.get(resultSet.getResultSet().getRequest().getBinding().getType());
            if (tab == null) {
                tab = this.mapURIToTab.get(resultSet.getBindingCategoryURI());
            }
        } else {
            tab = this.mapURIToTab.get(null);
        }
        assert (tab != null) : "No tab found for binding category: " + resultSet.getBindingCategoryURI() + "  search: " + resultSet.getResultSet().getRequest();
        tab.setCount(typeCount);
    }

    private void initFilterMap() {
        FILTER_PROPERTY_MAP = new HashMap<EIURI, List<DatatypePropertyInfo>>();
        EIEntity locationProperty = EIEntity.create((EIURI)EIURI.create((String)"http://www.obofoundry.org/ro/ro.owl#located_in"), (String)"Laboratory");
        DatatypePropertyInfo locationPropertyInfo = new DatatypePropertyInfo();
        locationPropertyInfo.property = locationProperty;
        locationPropertyInfo.valueDefaultText = "Laboratory Name";
        EIEntity manufacturerProperty = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000034"), (String)"Manufacturer");
        DatatypePropertyInfo manufacturerPropertyInfo = new DatatypePropertyInfo();
        manufacturerPropertyInfo.property = manufacturerProperty;
        manufacturerPropertyInfo.valueDefaultText = "Manufacturer Name";
        EIURI type = EIURI.create((String)"http://purl.obolibrary.org/obo/OBI_0100026");
        ArrayList<DatatypePropertyInfo> propInfoList = new ArrayList<DatatypePropertyInfo>();
        DatatypePropertyInfo propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://bogus"), (String)"Organism Type");
        propInfo.valueDefaultText = "Organism Type";
        propInfoList.add(propInfo);
        propInfoList.add(locationPropertyInfo);
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000233"), (String)"Models");
        propInfo.valueDefaultText = "Disease Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000006");
        propInfoList = new ArrayList();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000004");
        propInfoList = new ArrayList();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000005");
        propInfoList = new ArrayList();
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000015");
        propInfoList = new ArrayList();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://eagle-i.org/ont/data/Ctcondition"), (String)"Condition");
        propInfo.valueDefaultText = "Condition Name";
        propInfoList.add(propInfo);
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://eagle-i.org/ont/data/Ctintervention"), (String)"Intervention");
        propInfo.valueDefaultText = "Intervention Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000071");
        propInfoList = new ArrayList();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000070"), (String)"Laboratory");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
    }

    static class TypePropertyFilter
    extends PropertyFilter {
        private final TypeChooser<OntologyDropdown> subTypeChooser = new TypeChooser<OntologyDropdown>(new OntologyDropdown());
        private EIClass currentRootClass;

        TypePropertyFilter() {
            super("Type:");
            this.subTypeChooser.setTextBoxStyle("formText");
            this.add((Widget)this.subTypeChooser);
            this.currentRootClass = null;
            this.subTypeChooser.setClass(this.currentRootClass, false);
        }

        private void setClass(EIClass rootTypeClass, EIEntity selectedTypeEntity) {
            if (this.currentRootClass == null && rootTypeClass != null || this.currentRootClass != null && !this.currentRootClass.equals((Object)rootTypeClass)) {
                this.subTypeChooser.setClass(rootTypeClass, false);
                this.currentRootClass = rootTypeClass;
            }
            if (rootTypeClass != null && selectedTypeEntity != null && rootTypeClass.getEntity().getURI().equals((Object)selectedTypeEntity.getURI())) {
                this.subTypeChooser.setSelectedEntity(null);
            } else {
                this.subTypeChooser.setSelectedEntity(selectedTypeEntity);
            }
        }

        private EIURI getSelectedType() {
            return this.subTypeChooser.getSelectedURI();
        }
    }

    static class DatatypePropertyFilter
    extends PropertyFilter {
        private EIURI propertyURI;
        private TextBox valueTextBox;
        private String defaultText;

        DatatypePropertyFilter(String label, EIURI propertyURI, final String defaultText) {
            super(label);
            this.propertyURI = propertyURI;
            this.defaultText = defaultText;
            this.valueTextBox = new TextBox();
            this.valueTextBox.setStyleName("formText");
            this.add((Widget)this.valueTextBox);
            this.valueTextBox.setText(defaultText);
            this.valueTextBox.addStyleDependentName("default");
            this.valueTextBox.addFocusHandler(new FocusHandler(){

                public void onFocus(FocusEvent event) {
                    if (defaultText.equals(DatatypePropertyFilter.this.valueTextBox.getText())) {
                        DatatypePropertyFilter.this.setText("");
                    }
                }
            });
        }

        public void setText(String text) {
            this.valueTextBox.setText(text);
            this.valueTextBox.removeStyleDependentName("default");
        }

        EIURI getPropertyURI() {
            return this.propertyURI;
        }

        String getValue() {
            String text = this.valueTextBox.getText().trim();
            if (text.equals(this.defaultText)) {
                return "";
            }
            return text;
        }
    }

    static class PropertyFilter
    extends VerticalPanel {
        PropertyFilter(String label) {
            this.setStyleName("filterPanel");
            Label filterLabel = new Label(label);
            this.add((Widget)filterLabel);
            filterLabel.setStyleName("filterLabel");
        }
    }

    static class DatatypePropertyInfo {
        EIEntity property;
        String valueDefaultText;

        DatatypePropertyInfo() {
        }
    }

    private class ResourceTab
    extends AbstractTabPanel {
        private Anchor showFiltersLink;
        boolean expanded;

        ResourceTab(EIClass eiClass) {
            super(eiClass);
            this.showFiltersLink = new Anchor();
            this.add((Widget)this.showFiltersLink);
            this.showFiltersLink.addStyleName("tabSubLink");
            this.showFiltersLink.setVisible(false);
            this.showFiltersLink.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ResourceTab.this.setExpandFilters(!ResourceTab.this.expanded);
                }
            });
            this.setExpandFilters(false);
        }

        void setExpandFilters(boolean expanded) {
            if (!expanded) {
                this.showFiltersLink.setText("Show " + this.eiClass.getEntity().getLabel() + " Filters >>");
                for (int i = 1; i < this.getWidgetCount() - 1; ++i) {
                    this.getWidget(i).setVisible(false);
                }
            } else {
                this.showFiltersLink.setText("<< Hide " + this.eiClass.getEntity().getLabel() + " Filters");
                if (this.getWidgetCount() == 2) {
                    this.initFilters();
                }
                for (int i = 1; i < this.getWidgetCount() - 1; ++i) {
                    this.getWidget(i).setVisible(true);
                }
            }
            this.expanded = expanded;
        }

        @Override
        void setSelected(boolean selected) {
            super.setSelected(selected);
            if (!selected) {
                this.setExpandFilters(false);
            }
            this.showFiltersLink.setVisible(selected);
        }

        void initFilters() {
            List propEntityList;
            if (FILTER_PROPERTY_MAP == null) {
                ResourceTabSidebarComponent.this.initFilterMap();
            }
            if ((propEntityList = (List)FILTER_PROPERTY_MAP.get(this.eiClass.getEntity().getURI())) != null) {
                for (DatatypePropertyInfo pInfo : propEntityList) {
                    this.insert((Widget)new DatatypePropertyFilter(pInfo.property.getLabel(), pInfo.property.getURI(), pInfo.valueDefaultText), this.getWidgetCount() - 1);
                }
            }
        }
    }

    private class AllResourcesTab
    extends AbstractTabPanel {
        private Anchor browseLink;

        AllResourcesTab() {
            super(null);
            this.browseLink = new Anchor("Browse All Resources >>");
            this.add((Widget)this.browseLink);
            this.browseLink.addStyleName("tabSubLink");
            this.browseLink.setVisible(false);
        }

        @Override
        void setSelected(boolean selected) {
            super.setSelected(selected);
            this.browseLink.setVisible(selected);
        }
    }

    private abstract class AbstractTabPanel
    extends VerticalPanel {
        EIClass eiClass;
        private Anchor typeLabel;
        private Label countLabel;

        AbstractTabPanel(final EIClass eiClass) {
            this.eiClass = eiClass;
            this.setStyleName("tabPanel");
            HorizontalPanel mainLabelPanel = new HorizontalPanel();
            this.add((Widget)mainLabelPanel);
            mainLabelPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
            if (eiClass != null) {
                this.typeLabel = new Anchor(eiClass.getEntity().getLabel());
                this.setDefinition(eiClass.getDefinition());
            } else {
                this.typeLabel = new Anchor();
                this.typeLabel.setHTML("<b>All Resources</b>");
            }
            this.typeLabel.addStyleName("header_type_label");
            mainLabelPanel.add((Widget)this.typeLabel);
            this.countLabel = new Label();
            this.countLabel.setStyleName("header_type_count");
            mainLabelPanel.add((Widget)this.countLabel);
            mainLabelPanel.setCellWidth((Widget)this.countLabel, "100%");
            this.typeLabel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (eiClass == null && ResourceTabSidebarComponent.this.selectedType == null || eiClass != null && eiClass.getEntity().getURI().equals((Object)ResourceTabSidebarComponent.this.selectedType)) {
                        return;
                    }
                    if (eiClass != null) {
                        ResourceTabSidebarComponent.this.executeSearch(new SearchRequest.TypeBinding(eiClass.getEntity().getURI()));
                    } else {
                        ResourceTabSidebarComponent.this.executeSearch(null);
                    }
                }
            });
        }

        void setSelected(boolean selected) {
            if (selected) {
                this.addStyleDependentName("selected");
            } else {
                this.removeStyleDependentName("selected");
            }
        }

        void clearCount() {
            this.countLabel.setVisible(false);
        }

        void setCount(int count) {
            this.countLabel.setText("(" + count + ")");
            this.countLabel.setVisible(true);
        }

        void setDefinition(String definition) {
            this.typeLabel.setTitle(definition);
        }
    }
}

