package org.eaglei.ui.gwt.instance;

import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceX;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.LogoutPanel;
import org.eaglei.ui.gwt.ApplicationContext.ApplicationPage;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.SearchSidebarComponent;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;
import org.eaglei.ui.gwt.sidebar.SideBar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class InstancePage extends Composite implements SessionListener, ApplicationPage {

    private static final String URI_KEY = "uri";

    public static final InstanceServiceRemoteAsync instanceService = GWT
            .create(InstanceServiceRemote.class);

    private VerticalPanel instancePanel;
    private SearchSidebarComponent searchbox;
    private ContactSidebarComponent contact;
    private ReferencedBySidebarComponent references;
    
    private EIURI instanceID;

    public InstancePage() {
        VerticalPanel outer = new VerticalPanel();
        initWidget(outer);
        
        LogoutPanel logoutPanel = new LogoutPanel();
        outer.add(logoutPanel);
        logoutPanel.setStyleName("searchPageLogoutBox");

        HorizontalPanel mainPanel = new HorizontalPanel();
        SideBar sidebar = new SideBar();
        mainPanel.add(sidebar);
        DOM.setStyleAttribute(DOM.getParent(sidebar.getElement()), "borderRight", "1px solid #CCC");
        instancePanel = new VerticalPanel();
        instancePanel.setStyleName("instanceMainPanel");
        mainPanel.add(instancePanel);
        outer.add(mainPanel);
        
        contact = new ContactSidebarComponent();
        sidebar.addComponent(contact);
        references = new ReferencedBySidebarComponent();
        sidebar.addComponent(references);
        searchbox = new SearchSidebarComponent();
        sidebar.addComponent(searchbox);
        
        searchbox.setWidth("180px");
        contact.setWidth("180px");
        references.setWidth("180px");
    }

    @Override
    public Widget asWidget() {
         return this;
    }

    public void setPageParams(String params) {
        searchbox.setDefaultText();
        references.setReferences(null);
        
        String[] parts = params.split("=");
        if (parts.length != 2) {
            instancePanel.clear();
            instancePanel.add(new Label("Invalid URL, cannot display resource."));
        }
        
        if (! parts[0].equals(URI_KEY)) {
            instancePanel.clear();
            instancePanel.add(new Label("Invalid URL, cannot display resource."));
        }
        
        String uriStr = parts[1];
        instanceID = EIURI.create(uriStr);
        
        if (SessionContext.getSessionId() == null) {
            onLogOut();
            return;
        }
        
        displayContent();
    }
    
    private void displayContent() {  
        instancePanel.clear();
        instancePanel.add(new Image(ApplicationResources.INSTANCE.loading()));
        
        instanceService.getInstance(SessionContext.getSessionId(), instanceID, new AsyncCallback<EIInstanceX>() {

            @Override
            public void onFailure(Throwable caught) {
                instancePanel.clear();
                if (caught instanceof InvalidSessionIdException) {
                    SessionContext.INSTANCE.logOut();
                } else {
                    instancePanel.add(new HTML(caught.getLocalizedMessage()));
                }
            }

            @Override
            public void onSuccess(EIInstanceX result) {
                if (!result.instance.getInstanceURI().equals(instanceID)) {
                    // Another request has been made.
                    return;
                }
                instancePanel.clear();
                EIInstance instance = result.instance;
                // title
                Label instanceTitle = new Label(instance.getInstanceLabel());
                instancePanel.add(instanceTitle);
                instanceTitle.setStyleName("instanceTitle");
                // type
                Label instanceType = new Label(instance.getInstanceType().getLabel());
                instancePanel.add(instanceType);
                instanceType.setStyleName("instanceType");
                // properties
                ViewInstancePanel propertiesPanel = new ViewInstancePanel(instance, result.mapTermToDefinition);
                instancePanel.add(propertiesPanel);
                // references
                references.setReferences(result.references);
                // contact
                contact.setInstance(instance);
            }
            
        });
    }

    @Override
    public void onLogIn() {
        if (instanceID != null) {
            displayContent();
        }
    }

    @Override
    public void onLogOut() {
        instancePanel.clear();
        references.setReferences(null);
        instancePanel.add(new Label("Please login"));
    }

}
