package org.eaglei.ui.gwt.instance;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.PropertyCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.PropertyDefinitionCallback;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class InstancePanel extends Composite {

	protected final VerticalPanel outerFormPanel = new VerticalPanel();
	protected VerticalPanel formPanel = new VerticalPanel();
	protected EIInstance eiInstance;
	protected EIClass eiClass;
	protected EIClass rootSuperClass;
	// This list contains fully downloaded properties including definitions
	protected List<EIProperty> eiProperties;

	// TODO review - can we pass EIProperty instead?
	protected abstract void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues);

	protected abstract void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues);

	protected abstract void drawAdminProperties();

	protected abstract void drawReferencedBy();

	protected abstract void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties);

	protected abstract Collection<EIEntity> getDataTypeEntities();

	protected abstract Collection<EIEntity> getObjectTypeEntities();

	protected abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();

	protected abstract Collection<EIEntity> getNonOntologyResourcePropEntities();

	protected boolean shouldShowReadOnlyProperties;

	public InstancePanel(final EIInstance instance) {
		eiInstance = instance;

		initWidget(outerFormPanel);
		outerFormPanel.setStyleName("formPanel");
		formPanel.setStyleName("formPanel");
		initializeSpecifics();
	}

	protected InstancePanel() {
		// NOTE: ONLY to be called by subclasses that need to set other instance variables before doing stuff
		initWidget(outerFormPanel);
		outerFormPanel.setStyleName("formPanel");
		formPanel.setStyleName("formPanel");
	}

	protected void initializeSpecifics() {
		eiClass = eiInstance.getInstanceClass();
		initializeProperties();

		outerFormPanel.add(formPanel);
	}

	protected void finishSetup() {
		constructForm();
		formPanel.setStyleName("formPanel");
		formPanel.setHeight("50");
	}

	public EIInstance getInstance() {
		return eiInstance;
	}
	
    protected void addNameProperty(String labelPrefix) {
        final EIEntity namePropEntity = EIEntity.create(EagleIEntityConstants.RDFS_LABEL_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel(labelPrefix, EagleIEntityConstants.RDFS_LABEL_ENTITY.getLabel()));
        drawDataProperty(namePropEntity, "", true, makeSetFromSingle(eiInstance.getInstanceLabel()));
    }

    protected void addTypeProperty(String labelPrefix) {
        final EIEntity typePropEntity = EIEntity.create(EagleIEntityConstants.RDF_TYPE_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel(labelPrefix, EagleIEntityConstants.RDF_TYPE_ENTITY.getLabel()));
        drawObjectProperty(typePropEntity, "", true, makeSetFromSingleEntity(eiInstance.getInstanceType()));
    }

	protected void constructForm() {
		final Map<EIEntity, Set<String>> instanceDataTypeProperties = eiInstance.getDatatypeProperties();
		final Map<EIEntity, Set<EIEntity>> instanceObjectProperties = eiInstance.getObjectProperties();
		final Map<EIEntity, Set<String>> instanceNonOntologyLiteralProperties = eiInstance.getNonOntologyLiteralProperties();

		// TODO get lab label from EIClass
		String labelPrefix;
		if (InstanceWidgetUtils.isLabProperty(eiClass)) {
			labelPrefix = EagleIEntityConstants.EI_LAB_Label;
		} else {
			labelPrefix = rootSuperClass.getEntity().getLabel();
		}

		// Name and type go always first
		// TODO think about what definitions to use

		addNameProperty(labelPrefix);
		addTypeProperty(labelPrefix);

		// New order of display to make use of required properties

		/*
		 * for(EIEntity propEntity:getDataTypeEntities()) { drawDataProperty(propEntity, dataTypeProperties.get(propEntity)); }
		 * 
		 * for(EIEntity propEntity:getObjectTypeEntities()) { drawObjectProperty(propEntity, objectTypeProperties.get(propEntity)); }
		 */

		// These are the properties that should be displayed
		// For view: only those that are filled; for edit: all (set in the subclass)

		final Collection<EIEntity> dataProps = getDataTypeEntities();
		final Collection<EIEntity> objectProps = getObjectTypeEntities();
		// TODO this will likely change when restrictions are fleshed out in ontModel
		for (final EIProperty property : eiProperties) {
			if (property instanceof EIDatatypeProperty && dataProps.contains(property.getEntity())) {
				drawDataProperty(property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, instanceDataTypeProperties.get(property.getEntity()));
			} else if (property instanceof EIObjectProperty && objectProps.contains(property.getEntity())) {
				drawObjectProperty(property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, instanceObjectProperties.get(property.getEntity()));
			}
		}

		drawExtraFields(instanceNonOntologyLiteralProperties);
		drawReferencedBy();

		// final DisclosurePanel nonOntologyPanel = new DisclosurePanel( "Information for data curators" );

		drawAdminProperties();
		// final Map<EIEntity, Set<String>> nonOntLiteralList = eiInstance.getNonOntologyLiteralProperties();
		// final Map<EIEntity, Set<EIEntity>> nonOntResourceList = eiInstance.getNonOntologyResourceProperties();
		// final List<EIEntity> entityList = new ArrayList<EIEntity>();
		// entityList.addAll( eiInstance.getReadOnlyLiteralProperties().keySet() );
		// entityList.addAll( eiInstance.getReadOnlyResourceProperties().keySet() );
		// entityList.addAll( nonOntResourceList.keySet() );
		// entityList.addAll( nonOntLiteralList.keySet() );
		//
		// final VerticalPanel innerPanel = new VerticalPanel();
		// ClientRepositoryToolsManager.INSTANCE.retrieveLabels( entityList, new LabelsCallback() {
		// @Override
		// public void onSuccess(final Map<EIEntity, String> labelMap) {
		// createNonOntologyPanel( instanceNonOntologyLiteralProperties, instanceNonOntologyResourceProperties, labelMap, innerPanel );
		// }
		// } );
		//
		// nonOntologyPanel.add( innerPanel );
		// formPanel.add( nonOntologyPanel );

	}

	protected HashSet<String> makeSetFromSingle(final String value) {
		return new HashSet<String>(Arrays.asList(new String[] { value }));
	}

	protected HashSet<EIURI> makeSetFromSingleURI(final EIURI value) {
		return new HashSet<EIURI>(Arrays.asList(new EIURI[] { value }));
	}

	protected HashSet<EIEntity> makeSetFromSingleEntity(final EIEntity value) {
		return new HashSet<EIEntity>(Arrays.asList(new EIEntity[] { value }));
	}

	protected Widget handleReadOnlyTextProperty(final String value) {
		if (value.startsWith("www") || value.startsWith("http")) {
			// For values that have external URIs
			return new Anchor(InstanceWidgetUtils.formatText(value), InstanceWidgetUtils.formatText(value), "_blank");
		} else {
			final HTML valueField = new HTML(InstanceWidgetUtils.formatText( InstanceWidgetUtils.insertBreaks( value )));
			valueField.setStyleName("formLabelValue");
			return valueField;
		}
	}

	protected void drawReadOnlyLiteralProperty(final EIEntity propertyEntity, final Set<String> propertyValues, final Map<EIEntity, String> labelMap, final VerticalPanel nonOntologyPanel) {
		final String propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);

		final LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for (final String value : propertyValues) {
			widget.add(handleReadOnlyTextProperty(value));
		}
		nonOntologyPanel.add(widget);
	}

	protected void drawReadOnlyResourceProperty(final EIEntity propertyEntity, final Set<EIEntity> propertyValues, final Map<EIEntity, String> labelMap, final VerticalPanel nonOntologyPanel) {
		final String propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);

		final LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for (final EIEntity propEntity : propertyValues) {
			if (propEntity != null && propEntity != EIEntity.NULL_ENTITY) {
				widget.add(handleReadOnlyTextProperty(propEntity.getLabel()));
			}
		}
		nonOntologyPanel.add(widget);
	}

	protected void initializeProperties() {
		ClientModelManager.INSTANCE.getProperties(eiClass, new PropertyCallback() {
			@Override
			public void onSuccess(final EIClass result) {
				ClientModelManager.INSTANCE.getPropertyDefinitions(result.getProperties(), new PropertyDefinitionCallback() {
					@Override
					public void onSuccess(final List<EIProperty> properties) {
						eiProperties = properties;
						// finishSetup();
						getRootSuperClass();
					}
				});
			}
		});
	}

	protected void getRootSuperClass() {
		try {
			ClientModelManager.INSTANCE.getRootSuperClass(eiClass, new ClassCallback() {
				@Override
				public void onSuccess(final EIClass result) {
					rootSuperClass = result;
					finishSetup();
				}
			});

		} catch (LoggedException e) {
			// TODO: what to do here?
		}

	}
}
