package org.eaglei.ui.gwt.search.sidebar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassDefinitionCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.TopLevelClassesCallback;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.SearchRequest.TypeBinding;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.TermSuggestBox;
import org.eaglei.ui.gwt.search.SearchContext.SearchListener;
import org.eaglei.ui.gwt.search.results.OntologyDropdown;
import org.eaglei.ui.gwt.search.results.TypeChooser;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.security.SessionContext;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ResourceTabSidebarComponent extends VerticalPanel implements SearchListener {
    
    private abstract class AbstractTabPanel extends VerticalPanel {

        EIClass eiClass;
        private Anchor typeLabel;
        private Label countLabel;

        AbstractTabPanel(final EIClass eiClass) {
            this.eiClass = eiClass;
            setStyleName("tabPanel");
            /*
            if (eiClass != null) {
                // no icon
                Label icon = new Label();
                icon.setStyleName("tempIcon");
                add(icon);
            }
            */
            HorizontalPanel mainLabelPanel = new HorizontalPanel();
            add(mainLabelPanel);
            mainLabelPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);

            if (eiClass != null) {
                typeLabel = new Anchor(eiClass.getEntity().getLabel());
                //typeLabel.setStyleName("gwt_super_type");
                setDefinition(eiClass.getDefinition());
            } else {
                typeLabel = new Anchor();
                typeLabel.setHTML("<b>All Resources</b>");
            }
            typeLabel.addStyleName("header_type_label");

            mainLabelPanel.add(typeLabel);

            countLabel = new Label();
            countLabel.setStyleName("header_type_count");
            mainLabelPanel.add(countLabel);
            mainLabelPanel.setCellWidth(countLabel, "100%");

            typeLabel.addClickHandler(new ClickHandler() {

                @Override
                public void onClick(ClickEvent event) {
                    if ((eiClass == null && selectedType == null)
                            || (eiClass != null && eiClass.getEntity().getURI().equals(selectedType))) {
                        // No-op if this tab is already selected.
                        return;
                    }
                    if (eiClass != null) {
                        executeSearch(new TypeBinding(eiClass.getEntity().getURI()));
                    } else {
                        executeSearch(null);
                    }
                }
            });
        }
        
        void setSelected(boolean selected) {
            if (selected) {
                addStyleDependentName("selected");
            } else {
                removeStyleDependentName("selected");
            }
        }

        void clearCount() {
            countLabel.setVisible(false);
        }

        void setCount(int count) {
            countLabel.setText("(" + count + ")");
            countLabel.setVisible(true);
        }

        void setDefinition(String definition) {
            typeLabel.setTitle(definition);
        }
    }
    
    private class AllResourcesTab extends AbstractTabPanel {
        private Anchor browseLink;
        AllResourcesTab() {
            super(null);
            
            browseLink = new Anchor("Browse All Resources >>");
            add(browseLink);
            browseLink.addStyleName("tabSubLink");
            browseLink.setVisible(false);
        }
        
        void setSelected(boolean selected) {
            super.setSelected(selected);
            browseLink.setVisible(selected);
        }
    }

    private class ResourceTab extends AbstractTabPanel {
        private Anchor showFiltersLink;
        boolean expanded;
        
        ResourceTab(final EIClass eiClass) {
            super(eiClass);
            
            showFiltersLink = new Anchor();
            add(showFiltersLink);
            showFiltersLink.addStyleName("tabSubLink");
            showFiltersLink.setVisible(false);
            
            showFiltersLink.addClickHandler(new ClickHandler() {

                @Override
                public void onClick(ClickEvent event) {
                    setExpandFilters(!expanded);
                }
                
            });
            setExpandFilters(false);            
        }
        
        void setExpandFilters(boolean expanded) {
            if (!expanded) {
                showFiltersLink.setText("Show " + eiClass.getEntity().getLabel() + " Filters >>");
                for (int i=1; i<getWidgetCount()-1; i++) {
                    getWidget(i).setVisible(false);
                }
            } else {
                showFiltersLink.setText("<< Hide " + eiClass.getEntity().getLabel() + " Filters");
                if (getWidgetCount() == 2) {
                    initFilters();
                }
                for (int i=1; i<getWidgetCount()-1; i++) {
                    getWidget(i).setVisible(true);
                }
            }
            this.expanded = expanded;
        }
        
        void setSelected(boolean selected) {
            super.setSelected(selected);
            if (!selected) {
                setExpandFilters(false);
            }
            showFiltersLink.setVisible(selected);
        }
        
        void initFilters() {
            if (FILTER_PROPERTY_MAP == null) {
                // Only initialize the map when first needed.
                initFilterMap();
            }
            List<DatatypePropertyInfo> propEntityList = FILTER_PROPERTY_MAP.get(eiClass.getEntity().getURI());
            if (propEntityList != null) {
                for (DatatypePropertyInfo pInfo : propEntityList) {
                    insert(new DatatypePropertyFilter(pInfo.property.getLabel(), pInfo.property.getURI(), pInfo.valueDefaultText), getWidgetCount()-1);
                }
            }
        }
    }

    private List<EIClass> resourceTypes;
    //private final ResourceTypeTab allResourcesTab = new ResourceTypeTab(null);
    //private final FlexTable resourceTabTable = new FlexTable();
    private final Map<EIURI, AbstractTabPanel> mapURIToTab = new HashMap<EIURI, AbstractTabPanel>();
    private EIURI selectedType;
    private SearchCounts currentSearchCounts = null;

    public ResourceTabSidebarComponent() {
        /*
        ClientModelManager.INSTANCE.getTopLevelClasses(new TopLevelClassesCallback() {
            @Override
            public void onSuccess(List<EIClass> classList) {
                resourceTypes = classList;
                createPanel();
            }
        });
        */
        //ClientModelManager.INSTANCE.getClass(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000010"), new ClassCallback() {
            
            //@Override
            //public void onSuccess(final EIClass plasmid) {
                SearchContext.searchService.getTopLevelSearchCategories(new AsyncCallback<List<EIClass>>() {

                    @Override
                    public void onFailure(Throwable caught) {
                        // TODO Auto-generated method stub
                        
                    }

                    @Override
                    public void onSuccess(List<EIClass> result) {
                        //result.add(0, plasmid);
                        resourceTypes = result;
                        createPanel();
                    }
                });
            //}
        //});
    }

    /**
     * Creates the left panel. If the user is not logged in, it will display the
     * general view. For a valid user it displays an authenticated view.
     */
    private void createPanel() {
        setWidth("100");
        setStyleName("leftPanel");
        
        AbstractTabPanel allResourcesTab = new AllResourcesTab();
        add(allResourcesTab);
        //add(resourceTabTable);
        mapURIToTab.put(null, allResourcesTab);
        
        List<EIClass> listNoDefClasses = new ArrayList<EIClass>(resourceTypes.size());
        for (EIClass eclass : resourceTypes) {
            AbstractTabPanel tab = new ResourceTab(eclass);
            //resourceTabTable.setWidget(resourceTabTable.getRowCount(), 0, tab);
            add(tab);
            mapURIToTab.put(eclass.getEntity().getURI(), tab);
            if (eclass.getDefinition() == null) {
                listNoDefClasses.add(eclass);
            }
        }
        setToolTipforClass(listNoDefClasses);
        
        SearchContext.INSTANCE.addListener(this);
        // Initialize to any currently pending, or executed request.
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            getSearchCounts(SearchContext.INSTANCE.getCurrentRequest());
        }
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            onResults(SearchContext.INSTANCE.getCurrentResults());
        }
    }

    private void executeSearch(TypeBinding newBinding) {
        // Make a copy of the current request if there is one.
        SearchRequest currentRequest, newRequest;
        currentRequest = SearchContext.INSTANCE.getCurrentRequest();
        if (currentRequest != null) {
            newRequest = new SearchRequest(currentRequest.getTerm());
            newRequest.setInstitution(currentRequest.getInstitution());
        } else {
            newRequest = new SearchRequest();
        }
        newRequest.setBinding(newBinding);
        SearchContext.INSTANCE.search(newRequest);
        updateSelected(newRequest.getBinding() != null ? newRequest.getBinding().getType() : null);
    }

    private void setToolTipforClass(List<EIClass> listNoDefClasses) {
        ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses,
                new ClassDefinitionCallback() {
                    @Override
                    public void onSuccess(List<EIClass> result) {
                        for (EIClass clazz : result) {
                            AbstractTabPanel tab = mapURIToTab.get(clazz.getEntity().getURI());
                            tab.setDefinition(clazz.getDefinition());
                        }
                    }
                });
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRequestCreate(SearchRequest request) {
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            // no-op on page requests.
            return;
        }
        getSearchCounts(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        if (currentSearchCounts != null) {
            // The count response arrived before the result set.
            if (!results.getResultSet().getRequest().equals(currentSearchCounts.getRequest())) {
                // Unexpected. Cached counts request doesn't match result set request.
                // Maybe a new result set is about to arrive?
                return;
            }
            updateSearchCounts(currentSearchCounts, results);
        }
        // First see if binding can be matched to a custom tab URI
        EIURI tabURI = results.getResultSet().getRequest().getBinding() != null ? results.getResultSet().getRequest().getBinding().getType() : null;
        if (mapURIToTab.get(tabURI) == null) {
            tabURI = results.getBindingCategoryURI();
        }
        updateSelected(tabURI);
    }
    
    private void getSearchCounts(SearchRequest searchRequest) {
        currentSearchCounts = null;
        clearSearchCounts();
        if (searchRequest == null) {
            return;
        }
        final SearchCountRequest countRequest = new SearchCountRequest(searchRequest);
        // Creation of the count uri list is implemented server-side for a little perf
        // benefit.
        // Putting in deferred command to ensure that the result list request
        // gets executed first.  And the UI has a chance to go to display progress.
        DeferredCommand.addCommand(new Command() {

            @Override
            public void execute() {
                SearchContext.searchService.count(SessionContext.getSessionId(), countRequest,
                        new AsyncCallback<SearchCounts>() {

                            public void onFailure(Throwable caught) {
                                if (caught instanceof InvalidSessionIdException) {
                                    SessionContext.INSTANCE.logOut();
                                    return;
                                }
                            }

                            public void onSuccess(SearchCounts results) {
                                if (SearchContext.INSTANCE.getCurrentRequest() == null
                                        || !SearchContext.INSTANCE.getCurrentRequest().equals(
                                                results.getRequest())) {
                                    // Old request. no-op.
                                    return;
                                }
                                // Stash the current count response
                                currentSearchCounts = results;
                                if (SearchContext.INSTANCE.getCurrentResults() != null) {
                                    updateSearchCounts(results, SearchContext.INSTANCE.getCurrentResults());
                                }
                            }

                        });
            }
            
        });
    }

    private void updateSelected(EIURI selectedType) {
        this.selectedType = selectedType;
        for (EIURI tabURI : mapURIToTab.keySet()) {
            AbstractTabPanel tab = mapURIToTab.get(tabURI);
            if (tabURI == null) {
                // All Resources
                tab.setSelected(selectedType == null);
            } else {
                tab.setSelected(tabURI.equals(selectedType));
            }
        }
        /*
        if (selectedType == null) {
            allResourcesTab.setStyleName("panelSelected");
        } else {
            allResourcesTab.setStyleName("panelNotSelected");
        }
        int row = 0;
        for (EIClass t : resourceTypes) {
            if (t.getEntity().getURI().equals(selectedType)) {
                resourceTabTable.getRowFormatter().setStyleName(row++, "panelSelected");
            } else {
                resourceTabTable.getRowFormatter().setStyleName(row++, "panelNotSelected");
            }
        }
        */
    }
    
    private void clearSearchCounts() {
        for (AbstractTabPanel headerTab : mapURIToTab.values()) {
            headerTab.clearCount();
        }            
    }
    
    private void updateSearchCounts(SearchCounts counts, ClientSearchResultSet resultSet) {
        for (EIURI uri : counts.getClassesForCounts()) {
            int typeCount = counts.getClassCount(uri);
            AbstractTabPanel tab = mapURIToTab.get(uri);
            tab.setCount(typeCount);
        }
        int typeCount = resultSet.getResultSet().getTotalCount();
        AbstractTabPanel tab = null;
        // First check if binding URI can be matched to a custom tab URI.
        if (resultSet.getResultSet().getRequest().getBinding() != null) {
            tab = mapURIToTab.get(resultSet.getResultSet().getRequest().getBinding().getType());
            if (tab == null) {
                tab = mapURIToTab.get(resultSet.getBindingCategoryURI());
            }
        } else {
            // All resources tab
            tab = mapURIToTab.get(null);
        }
        assert (tab != null) : "No tab found for binding category: " + resultSet.getBindingCategoryURI() + "  search: " + resultSet.getResultSet().getRequest();
        tab.setCount(typeCount);
    }
    
    
    static class DatatypePropertyInfo {
        EIEntity property;
        String valueDefaultText;
    }
    
    static class PropertyFilter extends VerticalPanel {
        PropertyFilter(String label) {
            setStyleName("filterPanel");
            Label filterLabel = new Label(label);
            add(filterLabel);
            filterLabel.setStyleName("filterLabel");
        }
    }
    
    static class DatatypePropertyFilter extends PropertyFilter {
        
        private EIURI propertyURI;
        private TextBox valueTextBox;
        private String defaultText;
        
        DatatypePropertyFilter(String label, EIURI propertyURI, final String defaultText) {
            super(label);
            this.propertyURI = propertyURI;
            this.defaultText = defaultText;
            valueTextBox = new TextBox();
            valueTextBox.setStyleName("formText");
            add(valueTextBox);
            
            valueTextBox.setText(defaultText);
            valueTextBox.addStyleDependentName("default");
            valueTextBox.addFocusHandler(new FocusHandler() {
                public void onFocus(FocusEvent event) {
                    if (defaultText.equals(valueTextBox.getText())) {
                        setText("");
                    }
                }
            });
        }
        
        public void setText(String text) {
            valueTextBox.setText(text);
            valueTextBox.removeStyleDependentName("default");
        }
        
        EIURI getPropertyURI() {
            return this.propertyURI;
        }
        
        String getValue() {
            String text = valueTextBox.getText().trim();
            if (text.equals(defaultText)) {
                return "";
            } else {
                return text;
            }
        }
    }
        
    static class TypePropertyFilter extends PropertyFilter {

        private final TypeChooser<OntologyDropdown> subTypeChooser;
        private EIClass currentRootClass;

        TypePropertyFilter() {
            super("Type:");
            subTypeChooser = new TypeChooser<OntologyDropdown>(new OntologyDropdown());
            subTypeChooser.setTextBoxStyle("formText");
            add(subTypeChooser);
            
            // Initialize to null
            currentRootClass = null;
            subTypeChooser.setClass(currentRootClass, false);
        }
        
        private void setClass(EIClass rootTypeClass, EIEntity selectedTypeEntity) {
            if ((currentRootClass == null && rootTypeClass != null) 
                    || (currentRootClass != null && ! currentRootClass.equals(rootTypeClass))) {
                // Handle change in root class
                subTypeChooser.setClass(rootTypeClass, false);
                currentRootClass = rootTypeClass;
            }
            
            // Handle selected type
            if (rootTypeClass != null && selectedTypeEntity != null
                    && rootTypeClass.getEntity().getURI().equals(selectedTypeEntity.getURI())) {
                // If selected entity is same as root class,
                // treat it as a null value.
                subTypeChooser.setSelectedEntity(null);
            } else {
                subTypeChooser.setSelectedEntity(selectedTypeEntity);
            }
        }
        
        private EIURI getSelectedType() {
            return subTypeChooser.getSelectedURI();
        }
    }
    
    private static Map<EIURI, List<DatatypePropertyInfo>> FILTER_PROPERTY_MAP = null;
    
    private void initFilterMap() {
        ArrayList<DatatypePropertyInfo> propInfoList;
        FILTER_PROPERTY_MAP = new HashMap<EIURI, List<DatatypePropertyInfo>>();
        
        DatatypePropertyInfo propInfo;
        EIEntity locationProperty = EIEntity.create(EIURI.create("http://www.obofoundry.org/ro/ro.owl#located_in"), "Laboratory");
        DatatypePropertyInfo locationPropertyInfo = new DatatypePropertyInfo();
        locationPropertyInfo.property = locationProperty;
        locationPropertyInfo.valueDefaultText = "Laboratory Name";
        EIEntity manufacturerProperty = EIEntity.create(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000034"), "Manufacturer");
        DatatypePropertyInfo manufacturerPropertyInfo = new DatatypePropertyInfo();
        manufacturerPropertyInfo.property = manufacturerProperty;
        manufacturerPropertyInfo.valueDefaultText = "Manufacturer Name";
        
        // Organism
        EIURI type = EIURI.create("http://purl.obolibrary.org/obo/OBI_0100026"); 
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        //   Type
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI.create("http://bogus"), "Organism Type");
        propInfo.valueDefaultText = "Organism Type";
        propInfoList.add(propInfo);
        //   Location
        propInfoList.add(locationPropertyInfo);
        //   Disease Modeled
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000233"), "Models");
        propInfo.valueDefaultText = "Disease Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000006"); // Reagent
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000004"); // Instrument
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000005"); // Service
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        /*propEntityList.add(EIEntity.create(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000029"), "Provides access to"));*/
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000015"); // Human Study
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI.create("http://eagle-i.org/ont/data/Ctcondition"), "Condition");
        propInfo.valueDefaultText = "Condition Name";
        propInfoList.add(propInfo);
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI.create("http://eagle-i.org/ont/data/Ctintervention"), "Intervention");
        propInfo.valueDefaultText = "Intervention Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000071"); // Software
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000070"), "Laboratory");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
    }

}
