package org.eaglei.ui.gwt.sidebar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassDefinitionCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.TopLevelClassesCallback;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.SearchRequest.TypeBinding;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.SearchContext.SearchListener;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.security.SessionContext;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class LeftListPanel extends VerticalPanel implements SearchListener {

    private class ResourceTypeTab extends HorizontalPanel {

        private Anchor typeLabel;
        private Label countLabel;

        ResourceTypeTab(final EIClass eiClass) {
            /*
            if (eiClass != null) {
                // no icon
                Label icon = new Label();
                icon.setStyleName("tempIcon");
                add(icon);
            }
            */
            
            setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);

            if (eiClass != null) {
                typeLabel = new Anchor(eiClass.getEntity().getLabel());
                //typeLabel.setStyleName("gwt_super_type");
                setDefinition(eiClass.getDefinition());
            } else {
                typeLabel = new Anchor();
                typeLabel.setHTML("<b>All Resources</b>");
            }
            typeLabel.addStyleName("header_type_label");

            add(typeLabel);

            countLabel = new Label();
            countLabel.setStyleName("header_type_count");
            add(countLabel);
            setCellWidth(countLabel, "100%");

            typeLabel.addClickHandler(new ClickHandler() {

                @Override
                public void onClick(ClickEvent event) {
                    if ((eiClass == null && selectedType == null)
                            || (eiClass != null && eiClass.getEntity().getURI().equals(selectedType))) {
                        // No-op if this tab is already selected.
                        return;
                    }
                    EIURI selectedURI;
                    if (eiClass != null) {
                        selectedURI = eiClass.getEntity().getURI();
                        executeSearch(new TypeBinding(selectedURI));
                    } else {
                        selectedURI = null;
                        executeSearch(null);
                    }
                    updateSelected(selectedURI);
                }
            });
        }

        void clearCount() {
            countLabel.setVisible(false);
        }

        void setCount(int count) {
            countLabel.setText("(" + count + ")");
            countLabel.setVisible(true);
        }

        void setDefinition(String definition) {
            typeLabel.setTitle(definition);
        }
    }

    private List<EIClass> resourceTypes;
    //private final ResourceTypeTab allResourcesTab = new ResourceTypeTab(null);
    //private final FlexTable resourceTabTable = new FlexTable();
    private final Map<EIURI, ResourceTypeTab> mapURIToTab = new HashMap<EIURI, ResourceTypeTab>();
    private EIURI selectedType;
    private SearchCounts currentSearchCounts = null;

    public LeftListPanel() {
        /*
        ClientModelManager.INSTANCE.getTopLevelClasses(new TopLevelClassesCallback() {
            @Override
            public void onSuccess(List<EIClass> classList) {
                resourceTypes = classList;
                createPanel();
            }
        });
        */
        SearchContext.searchService.getTopLevelSearchCategories(new AsyncCallback<List<EIClass>>() {

            @Override
            public void onFailure(Throwable caught) {
                // TODO Auto-generated method stub
                
            }

            @Override
            public void onSuccess(List<EIClass> result) {
                resourceTypes = result;
                createPanel();
            }
        });
    }

    /**
     * Creates the left panel. If the user is not logged in, it will display the
     * general view. For a valid user it displays an authenticated view.
     */
    private void createPanel() {
        setWidth("100");
        setStyleName("leftPanel");
        
        ResourceTypeTab allResourcesTab = new ResourceTypeTab(null);
        add(allResourcesTab);
        //add(resourceTabTable);
        mapURIToTab.put(null, allResourcesTab);
        
        List<EIClass> listNoDefClasses = new ArrayList<EIClass>(resourceTypes.size());
        for (EIClass eclass : resourceTypes) {
            ResourceTypeTab tab = new ResourceTypeTab(eclass);
            //resourceTabTable.setWidget(resourceTabTable.getRowCount(), 0, tab);
            add(tab);
            mapURIToTab.put(eclass.getEntity().getURI(), tab);
            if (eclass.getDefinition() == null) {
                listNoDefClasses.add(eclass);
            }
        }
        setToolTipforClass(listNoDefClasses);

        SearchContext.INSTANCE.addListener(this);
        // Initialize to any currently pending, or executed request.
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            getSearchCounts(SearchContext.INSTANCE.getCurrentRequest());
        }
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            onResults(SearchContext.INSTANCE.getCurrentResults());
        }
    }

    /*
     * newBinding may be null
     */
    private void executeSearch(TypeBinding newBinding) {
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        SearchRequest newRequest;
        if (previousRequest != null) {
            // TODO: somewhat inefficient way to create a clone
            newRequest = new SearchRequest(previousRequest.toURLParams());
            newRequest.setStartIndex(0);
        } else {
            newRequest = new SearchRequest();
        }
        newRequest.setBinding(newBinding);
        SearchContext.INSTANCE.search(newRequest);
    }

    private void setToolTipforClass(List<EIClass> listNoDefClasses) {
        ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses,
                new ClassDefinitionCallback() {
                    @Override
                    public void onSuccess(List<EIClass> result) {
                        for (EIClass clazz : result) {
                            ResourceTypeTab tab = mapURIToTab.get(clazz.getEntity().getURI());
                            tab.setDefinition(clazz.getDefinition());
                        }
                    }
                });
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (!isAttached()) {
            return;
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (request.getDataset() != SearchRequest.DataSet.EI_RESOURCES) {
            // no-op
            return;
        }
        if (isPageRequest) {
            // no-op on page requests.
            return;
        }
        getSearchCounts(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        if (results.getResultSet().getRequest().getDataset() != SearchRequest.DataSet.EI_RESOURCES) {
            // no-op
            return;
        }
        if (currentSearchCounts != null) {
            // The count response arrived before the result set.
            if (!results.getResultSet().getRequest().equals(currentSearchCounts.getRequest())) {
                // Unexpected. Cached counts request doesn't match result set request.
                // Maybe a new result set is about to arrive?
                return;
            }
            updateSearchCounts(currentSearchCounts, results);
        }
        updateSelected(results.getBindingCategoryURI());
    }
    
    private void getSearchCounts(SearchRequest searchRequest) {
        currentSearchCounts = null;
        clearSearchCounts();
        if (searchRequest == null) {
            return;
        }
        final SearchCountRequest countRequest = new SearchCountRequest(searchRequest);
        // Creation of the count uri list is implemented server-side for a little perf
        // benefit.
        // Putting in deferred command to ensure that the result list request
        // gets executed first.  And the UI has a chance to go to display progress.
        DeferredCommand.addCommand(new Command() {

            @Override
            public void execute() {
                SearchContext.searchService.count(SessionContext.getSessionId(), countRequest,
                        new AsyncCallback<SearchCounts>() {

                            public void onFailure(Throwable caught) {
                                if (caught instanceof InvalidSessionIdException) {
                                    SessionContext.INSTANCE.logOut();
                                    return;
                                }
                            }

                            public void onSuccess(SearchCounts results) {
                                if (SearchContext.INSTANCE.getCurrentRequest() == null
                                        || !SearchContext.INSTANCE.getCurrentRequest().equals(
                                                results.getRequest())) {
                                    // Old request. no-op.
                                    return;
                                }
                                // Stash the current count response
                                currentSearchCounts = results;
                                if (SearchContext.INSTANCE.getCurrentResults() != null) {
                                    updateSearchCounts(results, SearchContext.INSTANCE.getCurrentResults());
                                }
                            }

                        });
            }
            
        });
    }

    private void updateSelected(EIURI selectedType) {
        this.selectedType = selectedType;
        for (EIURI tabURI : mapURIToTab.keySet()) {
            ResourceTypeTab headerTab = mapURIToTab.get(tabURI);
            if (tabURI == null) {
                // All Resources
                if (selectedType == null) {
                    headerTab.setStyleName("panelSelected");
                } else {
                    headerTab.setStyleName("panelNotSelected");
                }
            } else {
                if (tabURI.equals(selectedType)) {
                    headerTab.setStyleName("panelSelected");
                } else {
                    headerTab.setStyleName("panelNotSelected");
                }
            }
        }
        /*
        if (selectedType == null) {
            allResourcesTab.setStyleName("panelSelected");
        } else {
            allResourcesTab.setStyleName("panelNotSelected");
        }
        int row = 0;
        for (EIClass t : resourceTypes) {
            if (t.getEntity().getURI().equals(selectedType)) {
                resourceTabTable.getRowFormatter().setStyleName(row++, "panelSelected");
            } else {
                resourceTabTable.getRowFormatter().setStyleName(row++, "panelNotSelected");
            }
        }
        */
    }
    
    private void clearSearchCounts() {
        for (ResourceTypeTab headerTab : mapURIToTab.values()) {
            headerTab.clearCount();
        }            
    }
    
    private void updateSearchCounts(SearchCounts counts, ClientSearchResultSet resultSet) {
        for (EIURI uri : counts.getClassesForCounts()) {
            int typeCount = counts.getClassCount(uri);
            ResourceTypeTab tab = mapURIToTab.get(uri);
            tab.setCount(typeCount);
        }
        int typeCount = resultSet.getResultSet().getTotalCount();
        ResourceTypeTab tab = mapURIToTab.get(resultSet.getBindingCategoryURI());
        assert (tab != null) : "No tab found for binding category: " + resultSet.getBindingCategoryURI() + "  search: " + resultSet.getResultSet().getRequest();
        tab.setCount(typeCount);
    }
}
