/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.instance.InstancePanel;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

public class ViewInstancePanel
extends InstancePanel {
    private static final InstanceServiceRemoteAsync instanceService = (InstanceServiceRemoteAsync)GWT.create(InstanceServiceRemote.class);
    private Map<EIURI, String> mapTermToDefinition;

    public ViewInstancePanel(EIInstance instance, Map<EIURI, String> mapTermToDefinition) {
        super(instance);
        this.mapTermToDefinition = mapTermToDefinition;
    }

    @Override
    protected void initializeSpecifics() {
        this.outerFormPanel.add((Widget)new Image(ApplicationResources.INSTANCE.loading()));
        super.initializeSpecifics();
    }

    @Override
    protected void finishSetup() {
        this.outerFormPanel.remove(0);
        super.finishSetup();
    }

    @Override
    protected void addNameProperty(String labelPrefix) {
    }

    @Override
    protected void addTypeProperty(String labelPrefix) {
    }

    @Override
    protected void drawAdminProperties() {
    }

    @Override
    protected void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues) {
        LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
        this.formPanel.add((Widget)widget);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
    }

    @Override
    protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
    }

    @Override
    protected void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues) {
        LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
        this.formPanel.add((Widget)widget);
        boolean hadValue = false;
        TreeSet<EIEntity> alphaSet = new TreeSet<EIEntity>(propertyValues);
        for (EIEntity entity : alphaSet) {
            String termDefinition;
            if (entity == null || entity == EIEntity.NULL_ENTITY || entity.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) continue;
            hadValue = true;
            String string = termDefinition = this.mapTermToDefinition != null ? this.mapTermToDefinition.get(entity.getURI()) : null;
            if (termDefinition == null) {
                Hyperlink instanceLink = new Hyperlink(InstanceWidgetUtils.formatText(entity.getLabel()), "inst/uri=" + entity.getURI().toString());
                widget.add((Widget)instanceLink);
                continue;
            }
            Label valueField = new Label(entity.getLabel());
            valueField.setStyleName("formLabelValue");
            widget.add((Widget)valueField);
            valueField.setTitle(termDefinition);
        }
        if (!hadValue) {
            this.formPanel.remove((Widget)widget);
        }
    }

    @Override
    protected void drawReferencedBy() {
    }

    @Override
    protected Collection<EIEntity> getDataTypeEntities() {
        return this.eiInstance.getDatatypeProperties().keySet();
    }

    @Override
    protected Collection<EIEntity> getNonOntologyLiteralPropEntities() {
        return null;
    }

    @Override
    protected Collection<EIEntity> getNonOntologyResourcePropEntities() {
        return null;
    }

    @Override
    protected Collection<EIEntity> getObjectTypeEntities() {
        return this.eiInstance.getObjectProperties().keySet();
    }
}

