/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.suggest.client.AbstractSearchBox;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.TermSuggestBox;

public class SearchSidebarComponent
extends Composite {
    VerticalPanel outerPanel = new VerticalPanel();
    private HorizontalPanel searchBarPanel = new HorizontalPanel();
    TermSuggestBox termBox;

    public SearchSidebarComponent() {
        this.initWidget((Widget)this.outerPanel);
        this.setStyleName("searchboxSidebarComponent");
        Label title = new Label("Search");
        this.outerPanel.add((Widget)title);
        title.setStyleName("title");
        this.outerPanel.add((Widget)this.searchBarPanel);
        this.termBox = new TermSuggestBox(){

            @Override
            public String getDefaultText() {
                return super.getDefaultText();
            }
        };
        this.searchBarPanel.add((Widget)this.termBox);
        this.termBox.addStyleName("search_widget");
        this.termBox.addSearchHandler(new AbstractSearchBox.SearchHandler(){

            public void performSearch(String query, String uri) {
                SearchRequest.Term term = new SearchRequest.Term(query, uri != null ? EIURI.create((String)uri) : null);
                SearchRequest request = SearchSidebarComponent.this.getSearchRequest();
                SearchContext.INSTANCE.search(request);
            }
        }, true, true);
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this.termBox.setWidth(width);
    }

    public void setDefaultText() {
        this.termBox.setDefaultText();
    }

    private SearchRequest getSearchRequest() {
        SearchRequest.Term term = null;
        String query = this.termBox.getText();
        if (query != null) {
            query.trim();
            if (query.length() > 0) {
                term = new SearchRequest.Term(query);
            }
        }
        SearchRequest request = new SearchRequest();
        request.setTerm(term);
        return request;
    }
}

