/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.ui.gwt.LogoutPanel;
import org.eaglei.ui.gwt.TopPanel;
import org.eaglei.ui.gwt.search.SearchBar;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.NavBar;
import org.eaglei.ui.gwt.search.results.ResourcesGrid;
import org.eaglei.ui.gwt.search.results.SidebarFilterPanel;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.sidebar.LeftListPanel;
import org.eaglei.ui.gwt.sidebar.SideBar;

public class ResultsPage
extends Composite
implements SearchContext.SearchListener {
    private static final EIURI JOURNAL_URI = EIURI.create((String)"journal");
    private static final EIURI DATE_URI = EIURI.create((String)"date");
    private static final EIURI ORGANISM_URI = EIURI.create((String)"organism");
    private static final EIURI AKA_URI = EIURI.create((String)"aka");
    private static final EIURI REPOSITORY_URI = EIURI.create((String)"repository");
    private VerticalPanel outer = new VerticalPanel();
    private FlowPanel repoTabBar = new FlowPanel();
    private HorizontalPanel mainPanel = new HorizontalPanel();
    private SideBar sidebar;
    private VerticalPanel dataPanel;
    private SearchBar searchBar;
    private ResourcesGrid resultsGrid;
    private SearchRequest.DataSet selectedDataset = null;
    private final Map<SearchRequest.DataSet, RepositoryTab> mapIDToTab = new HashMap<SearchRequest.DataSet, RepositoryTab>();

    public ResultsPage() {
        this.initWidget((Widget)this.outer);
        this.outer.setStyleName("resultsPageOuter");
        LogoutPanel logoutPanel = new LogoutPanel();
        this.outer.add((Widget)logoutPanel);
        logoutPanel.setStyleName("searchPageLogoutBox");
        this.searchBar = new SearchBar(false);
        this.outer.add((Widget)this.searchBar);
        this.outer.add((Widget)this.repoTabBar);
        this.repoTabBar.addStyleName("repoTabBar");
        this.outer.add((Widget)this.mainPanel);
        RepositoryTab tab = new RepositoryTab(SearchRequest.DataSet.EI_RESOURCES, "eagle-i", "Search eagle-i for research resources");
        this.mapIDToTab.put(tab.dataset, tab);
        this.repoTabBar.add((Widget)tab);
        tab = new RepositoryTab(SearchRequest.DataSet.NIF_RESOURCES, "NIF", "Search NIF for research resources");
        this.mapIDToTab.put(tab.dataset, tab);
        this.repoTabBar.add((Widget)tab);
        tab = new RepositoryTab(SearchRequest.DataSet.PUBS, "PubMed", "Search for publications");
        this.mapIDToTab.put(tab.dataset, tab);
        this.repoTabBar.add((Widget)tab);
        tab = new RepositoryTab(SearchRequest.DataSet.GENES, "Entrez Gene", "Search for genes");
        this.mapIDToTab.put(tab.dataset, tab);
        this.repoTabBar.add((Widget)tab);
        this.sidebar = new SideBar();
        this.mainPanel.add((Widget)this.sidebar);
        LeftListPanel listPanel = new LeftListPanel();
        this.sidebar.add((Widget)listPanel);
        SidebarFilterPanel filterPanel = new SidebarFilterPanel();
        this.sidebar.add((Widget)filterPanel);
        this.dataPanel = new VerticalPanel();
        this.dataPanel.setStyleName("dataPanel");
        this.mainPanel.add((Widget)this.dataPanel);
        NavBar navBar = new NavBar();
        this.dataPanel.add((Widget)navBar);
        this.resultsGrid = new ResourcesGrid(navBar);
        this.dataPanel.add((Widget)this.resultsGrid);
        String[] resourceColumnNames = new String[]{"Resource Name", "Type", "Location"};
        ResourcesGrid.DataSetRenderer renderer = new ResourcesGrid.DataSetRenderer(this.resultsGrid, SearchRequest.DataSet.EI_RESOURCES, resourceColumnNames);
        this.resultsGrid.addRenderer(renderer);
        renderer = new ResourcesGrid.DataSetRenderer(this.resultsGrid, SearchRequest.DataSet.NIF_RESOURCES, resourceColumnNames){

            @Override
            public void createInstanceRow(int row, SearchRequest.DataSet dataset, SearchResult searchResult) {
                int col = 0;
                HTML instanceLink = new HTML(searchResult.getURL());
                HTML snippit = null;
                if (searchResult.getHighlight() != null) {
                    snippit = new HTML(searchResult.getHighlight());
                }
                ResourcesGrid.CellPanel cp = new ResourcesGrid.CellPanel();
                cp.setContent((Widget)instanceLink, (Widget)snippit);
                this.resultsTable.setWidget(row, col++, (Widget)cp);
                Label typeLabel = new Label(searchResult.getType().getLabel());
                Widget rootTypeLabel = null;
                cp = new ResourcesGrid.CellPanel();
                cp.setContent((Widget)typeLabel, rootTypeLabel);
                if (rootTypeLabel != null) {
                    rootTypeLabel.addStyleName("rootType");
                }
                this.resultsTable.setWidget(row, col++, (Widget)cp);
                Set repoList = searchResult.getDataTypeProperty(REPOSITORY_URI);
                Iterator i$ = repoList.iterator();
                if (i$.hasNext()) {
                    String repo = (String)i$.next();
                    Label repoLabel = new Label(repo);
                    cp = new ResourcesGrid.CellPanel();
                    cp.setContent((Widget)repoLabel, null);
                }
                cp.addStyleName("noWrapCell");
                this.resultsTable.setWidget(row, col++, (Widget)cp);
            }
        };
        this.resultsGrid.addRenderer(renderer);
        String[] pubColumnNames = new String[]{"Title", "Journal", "Date"};
        renderer = new ResourcesGrid.DataSetRenderer(this.resultsGrid, SearchRequest.DataSet.PUBS, pubColumnNames){

            @Override
            public void createInstanceRow(int row, SearchRequest.DataSet dataset, SearchResult searchResult) {
                Anchor instanceLink;
                int col = 0;
                if (dataset == SearchRequest.DataSet.EI_RESOURCES) {
                    instanceLink = new Hyperlink(searchResult.getEntity().getLabel(), "inst/uri=" + searchResult.getEntity().getURI().toString());
                } else {
                    instanceLink = new Anchor(searchResult.getEntity().getLabel(), searchResult.getEntity().getURI().toString());
                    instanceLink.setTarget("_blank");
                }
                HTML snippit = null;
                if (searchResult.getHighlight() != null) {
                    snippit = new HTML(searchResult.getHighlight());
                }
                ResourcesGrid.CellPanel cp = new ResourcesGrid.CellPanel();
                cp.setContent((Widget)instanceLink, (Widget)snippit);
                this.resultsTable.setWidget(row, col++, (Widget)cp);
                Set journalList = searchResult.getDataTypeProperty(JOURNAL_URI);
                Iterator i$ = journalList.iterator();
                if (i$.hasNext()) {
                    String journal = (String)i$.next();
                    Label typeLabel = new Label(journal);
                    cp = new ResourcesGrid.CellPanel();
                    cp.setContent((Widget)typeLabel, null);
                }
                this.resultsTable.setWidget(row, col++, (Widget)cp);
                Set dateList = searchResult.getDataTypeProperty(DATE_URI);
                Iterator i$2 = dateList.iterator();
                if (i$2.hasNext()) {
                    String date = (String)i$2.next();
                    Label typeLabel = new Label(date);
                    cp = new ResourcesGrid.CellPanel();
                    cp.setContent((Widget)typeLabel, null);
                }
                cp.addStyleName("noWrapCell");
                this.resultsTable.setWidget(row, col++, (Widget)cp);
            }
        };
        this.resultsGrid.addRenderer(renderer);
        String[] geneColumnNames = new String[]{"Full Name", "Organism", "Also Known As"};
        renderer = new ResourcesGrid.DataSetRenderer(this.resultsGrid, SearchRequest.DataSet.GENES, geneColumnNames){

            @Override
            public void createInstanceRow(int row, SearchRequest.DataSet dataset, SearchResult searchResult) {
                Anchor instanceLink;
                int col = 0;
                if (dataset == SearchRequest.DataSet.EI_RESOURCES) {
                    instanceLink = new Hyperlink(searchResult.getEntity().getLabel(), "inst/uri=" + searchResult.getEntity().getURI().toString());
                } else {
                    instanceLink = new Anchor(searchResult.getEntity().getLabel(), searchResult.getEntity().getURI().toString());
                    instanceLink.setTarget("_blank");
                }
                HTML snippit = null;
                if (searchResult.getHighlight() != null) {
                    snippit = new HTML(searchResult.getHighlight());
                }
                ResourcesGrid.CellPanel cp = new ResourcesGrid.CellPanel();
                cp.setContent((Widget)instanceLink, (Widget)snippit);
                this.resultsTable.setWidget(row, col++, (Widget)cp);
                Set organismList = searchResult.getDataTypeProperty(ORGANISM_URI);
                Iterator i$ = organismList.iterator();
                if (i$.hasNext()) {
                    String organism = (String)i$.next();
                    Label orgLabel = new Label(organism);
                    cp = new ResourcesGrid.CellPanel();
                    cp.setContent((Widget)orgLabel, null);
                }
                this.resultsTable.setWidget(row, col++, (Widget)cp);
                Set akaList = searchResult.getDataTypeProperty(AKA_URI);
                Iterator i$2 = akaList.iterator();
                if (i$2.hasNext()) {
                    String aka = (String)i$2.next();
                    Label typeLabel = new Label(aka);
                    cp = new ResourcesGrid.CellPanel();
                    cp.setContent((Widget)typeLabel, null);
                }
                this.resultsTable.setWidget(row, col++, (Widget)cp);
            }
        };
        this.resultsGrid.addRenderer(renderer);
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            this.onResults(SearchContext.INSTANCE.getCurrentResults());
        } else if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.onRequestPending(SearchContext.INSTANCE.getCurrentRequest(), false);
        }
        SearchContext.INSTANCE.addListener(this);
    }

    public void setHeaderPanel(TopPanel topPanel) {
    }

    public void setPageParams(String params) {
        SearchContext.INSTANCE.setFromHistoryParams(params);
    }

    private void executeSearch(SearchRequest.DataSet dataset) {
        if (this.selectedDataset == dataset) {
            return;
        }
        this.updateSelectedRepo(dataset);
        SearchRequest currentRequest = SearchContext.INSTANCE.getCurrentRequest();
        SearchRequest newRequest = currentRequest != null ? new SearchRequest(currentRequest.getTerm()) : new SearchRequest();
        newRequest.setDataset(dataset);
        SearchContext.INSTANCE.search(newRequest);
    }

    void updateSelectedRepo(SearchRequest.DataSet selectedDataset) {
        if (this.selectedDataset == selectedDataset) {
            return;
        }
        this.selectedDataset = selectedDataset;
        for (RepositoryTab tab : this.mapIDToTab.values()) {
            if (selectedDataset == null) {
                tab.displaySelected(tab.dataset == SearchRequest.DEFAULT_DATASET);
                continue;
            }
            tab.displaySelected(tab.dataset == selectedDataset);
        }
        this.updateLayout(selectedDataset);
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        this.resultsGrid.displayStatusMessage(message);
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (!this.isAttached()) {
            return;
        }
        request.setDataset(this.selectedDataset);
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        this.updateSelectedRepo(request.getDataset());
        if (request == null) {
            this.resultsGrid.displayStatusMessage("");
        } else {
            this.resultsGrid.displaySearchPending();
        }
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        this.updateSelectedRepo(results.getResultSet().getRequest().getDataset());
        this.resultsGrid.displaySearchResults(results);
    }

    private void updateLayout(SearchRequest.DataSet dataset) {
        if (dataset == SearchRequest.DataSet.EI_RESOURCES) {
            this.dataPanel.setWidth("635px");
            this.resultsGrid.setWidth("635px");
            this.sidebar.setVisible(true);
        } else {
            this.dataPanel.setWidth("830px");
            this.resultsGrid.setWidth("830px");
            this.sidebar.setVisible(false);
        }
    }

    private class RepositoryTab
    extends RadioButton {
        SearchRequest.DataSet dataset;

        RepositoryTab(final SearchRequest.DataSet dataset, String label, String tooltip) {
            super("RepoSelect", label);
            this.setStyleName("repoTab");
            this.dataset = dataset;
            this.setTitle(tooltip);
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        ResultsPage.this.executeSearch(dataset);
                    }
                }
            });
        }

        void displaySelected(boolean selected) {
            this.setValue(selected);
        }
    }

    static interface ResultsResources
    extends ClientBundle {
        @CssResource.NotStrict
        @ClientBundle.Source(value={"results.css"})
        public CssResource css();
    }
}

