/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;

public class SidebarFilterPanel
extends Composite
implements SearchContext.SearchListener {
    public static boolean HAS_INSTITUTION_SELECT;
    VerticalPanel filterListPanel = new VerticalPanel();
    private int typeFilterStartIndex;
    private InstitutionPropertyFilter institutionPropertyFilter;
    private EIClass currentRootClass;
    private SearchRequest currentRequest = null;
    private static Map<EIURI, List<DatatypePropertyInfo>> FILTER_PROPERTY_MAP;

    public SidebarFilterPanel() {
        this.initWidget((Widget)this.filterListPanel);
        this.setStyleName("filterSidebarComponent");
        if (!ApplicationContext.IS_INSTITUTION) {
            this.institutionPropertyFilter = new InstitutionPropertyFilter();
            this.filterListPanel.add((Widget)this.institutionPropertyFilter);
            this.typeFilterStartIndex = 1;
        } else {
            this.typeFilterStartIndex = 0;
        }
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        SearchContext.INSTANCE.addListener(this);
    }

    public EIURI getResourceType() {
        return this.currentRootClass.getEntity().getURI();
    }

    private void setResourceType(EIURI rootTypeURI, final EIEntity selectedTypeEntity) {
        if (rootTypeURI == null) {
            this.setResourceType((EIClass)null, selectedTypeEntity);
        } else {
            ClientModelManager.INSTANCE.getClass(rootTypeURI, new ClientModelManager.ClassCallback(){

                public void onSuccess(EIClass result) {
                    SidebarFilterPanel.this.setResourceType(result, selectedTypeEntity);
                }
            });
        }
    }

    private void setResourceType(EIClass rootTypeClass, EIEntity selectedTypeEntity) {
        if (this.currentRootClass == null && rootTypeClass != null || this.currentRootClass != null && !this.currentRootClass.equals((Object)rootTypeClass)) {
            this.updateTypeFilters(rootTypeClass);
        }
        this.currentRootClass = rootTypeClass;
    }

    private void updateTypeFilters(EIClass rootTypeClass) {
        List<DatatypePropertyInfo> propEntityList;
        for (int i = this.filterListPanel.getWidgetCount() - 1; i >= this.typeFilterStartIndex; --i) {
            this.filterListPanel.remove(i);
        }
        if (rootTypeClass == null) {
            return;
        }
        if (FILTER_PROPERTY_MAP == null) {
            this.initFilterMap();
        }
        if ((propEntityList = FILTER_PROPERTY_MAP.get(rootTypeClass.getEntity().getURI())) != null) {
            for (DatatypePropertyInfo pInfo : propEntityList) {
                this.filterListPanel.add((Widget)new DatatypePropertyFilter(pInfo.property.getLabel(), pInfo.property.getURI(), pInfo.valueDefaultText));
            }
        }
    }

    private void initFilterMap() {
        FILTER_PROPERTY_MAP = new HashMap<EIURI, List<DatatypePropertyInfo>>();
        EIEntity locationProperty = EIEntity.create((EIURI)EIURI.create((String)"http://www.obofoundry.org/ro/ro.owl#located_in"), (String)"Laboratory");
        DatatypePropertyInfo locationPropertyInfo = new DatatypePropertyInfo();
        locationPropertyInfo.property = locationProperty;
        locationPropertyInfo.valueDefaultText = "Laboratory Name";
        EIEntity manufacturerProperty = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000034"), (String)"Manufacturer");
        DatatypePropertyInfo manufacturerPropertyInfo = new DatatypePropertyInfo();
        manufacturerPropertyInfo.property = manufacturerProperty;
        manufacturerPropertyInfo.valueDefaultText = "Manufacturer Name";
        EIURI type = EIURI.create((String)"http://purl.obolibrary.org/obo/OBI_0100026");
        ArrayList<DatatypePropertyInfo> propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfoList.add(locationPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000006");
        propInfoList = new ArrayList();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000004");
        propInfoList = new ArrayList();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000005");
        propInfoList = new ArrayList();
        DatatypePropertyInfo propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000390"), (String)"Laboratory");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/OBI_0000272");
        propInfoList = new ArrayList();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000070"), (String)"Laboratory");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000015");
        propInfoList = new ArrayList();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://eagle-i.org/ont/data/human_study_performed_by"), (String)"Laboratory");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        type = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000071");
        propInfoList = new ArrayList();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000070"), (String)"Laboratory");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (!this.isAttached()) {
            return;
        }
        if (request.getDataset() != SearchRequest.DataSet.EI_RESOURCES) {
            request.setInstitution(null);
            if (request.getBinding() != null && request.getBinding().getDataTypeProperties() != null) {
                request.getBinding().getDataTypeProperties().clear();
            }
            return;
        }
        if (this.institutionPropertyFilter != null) {
            request.setInstitution(this.institutionPropertyFilter.getSelectedInstitution());
        } else {
            request.setInstitution(null);
        }
        SearchRequest.TypeBinding binding = request.getBinding();
        if (binding != null) {
            if (binding.getDataTypeProperties() != null) {
                binding.getDataTypeProperties().clear();
            }
            if (this.currentRootClass != null && binding.getType().equals((Object)this.currentRootClass.getEntity().getURI())) {
                for (int i = this.typeFilterStartIndex; i < this.filterListPanel.getWidgetCount(); ++i) {
                    DatatypePropertyFilter propFilter = (DatatypePropertyFilter)this.filterListPanel.getWidget(i);
                    propFilter.addProperty(binding);
                }
            }
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        this.setSearchRequest(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        this.setResourceType(results.getBindingCategoryURI(), results.getBindingEntity());
    }

    private void setSearchRequest(SearchRequest request) {
        if (this.institutionPropertyFilter != null) {
            this.institutionPropertyFilter.setInstitution(request.getInstitution());
        }
        EIURI typeCategoryURI = request != null && request.getBinding() != null ? request.getBinding().getType() : null;
        this.setResourceType(typeCategoryURI, null);
        this.currentRequest = request;
    }

    static {
        FILTER_PROPERTY_MAP = null;
    }

    static interface Binder
    extends UiBinder<Widget, SidebarFilterPanel> {
    }

    static class DatatypePropertyFilter
    extends PropertyFilter {
        private EIURI propertyURI;
        private TextBox valueTextBox;
        private String defaultText;

        DatatypePropertyFilter(String label, EIURI propertyURI, final String defaultText) {
            super(label);
            this.propertyURI = propertyURI;
            this.defaultText = defaultText;
            this.valueTextBox = new TextBox();
            this.add((Widget)this.valueTextBox);
            this.valueTextBox.setStyleName("valueText");
            this.valueTextBox.addStyleName("value");
            this.valueTextBox.setText(defaultText);
            this.valueTextBox.addStyleDependentName("default");
            this.valueTextBox.addFocusHandler(new FocusHandler(){

                public void onFocus(FocusEvent event) {
                    if (defaultText.equals(DatatypePropertyFilter.this.valueTextBox.getText())) {
                        DatatypePropertyFilter.this.setText("");
                    }
                }
            });
            this.valueTextBox.addKeyUpHandler(new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    if (event.getNativeKeyCode() == 13) {
                        DatatypePropertyFilter.this.executeSearch();
                    }
                }
            });
        }

        public void setText(String text) {
            this.valueTextBox.setText(text);
            this.valueTextBox.removeStyleDependentName("default");
        }

        EIURI getPropertyURI() {
            return this.propertyURI;
        }

        String getValue() {
            String text = this.valueTextBox.getText().trim();
            if (text.equals(this.defaultText)) {
                return "";
            }
            return text;
        }

        private void executeSearch() {
            SearchRequest newRequest;
            SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
            if (previousRequest != null) {
                newRequest = new SearchRequest(previousRequest.toURLParams());
                newRequest.setStartIndex(0);
            } else {
                newRequest = new SearchRequest();
            }
            SearchRequest.TypeBinding binding = newRequest.getBinding();
            if (binding == null) {
                return;
            }
            this.addProperty(binding);
            SearchContext.INSTANCE.search(newRequest);
        }

        void addProperty(SearchRequest.TypeBinding binding) {
            EIURI propURI = this.getPropertyURI();
            binding.getDataTypeProperties().remove(propURI);
            String value = this.getValue();
            if (value.length() > 0) {
                binding.addDataTypeProperty(propURI, value);
            }
        }
    }

    static class InstitutionPropertyFilter
    extends PropertyFilter {
        private List<EIEntity> listInstitutionEntities = null;
        private ListBox institutionListBox = new ListBox();
        private EIURI currentInstitution;

        InstitutionPropertyFilter() {
            super("Institution");
            this.add((Widget)this.institutionListBox);
            this.institutionListBox.setStyleName("value");
            this.institutionListBox.addStyleName("valueListBox");
            this.institutionListBox.addItem("All Institutions");
            this.initInstitutionList();
            this.institutionListBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    EIURI selectedInstitution = InstitutionPropertyFilter.this.institutionListBox.getSelectedIndex() > 0 ? ((EIEntity)InstitutionPropertyFilter.this.listInstitutionEntities.get(InstitutionPropertyFilter.this.institutionListBox.getSelectedIndex() - 1)).getURI() : null;
                    if (selectedInstitution == null && InstitutionPropertyFilter.this.currentInstitution != null || !selectedInstitution.equals((Object)InstitutionPropertyFilter.this.currentInstitution)) {
                        InstitutionPropertyFilter.this.currentInstitution = selectedInstitution;
                        InstitutionPropertyFilter.this.executeSearch();
                    }
                }
            });
        }

        private void initInstitutionList() {
            SearchServiceRemoteAsync searchService = (SearchServiceRemoteAsync)GWT.create(SearchServiceRemote.class);
            searchService.getInstitutions(new AsyncCallback<List<EIEntity>>(){

                public void onSuccess(List<EIEntity> result) {
                    InstitutionPropertyFilter.this.listInstitutionEntities = result;
                    for (EIEntity institution : result) {
                        InstitutionPropertyFilter.this.institutionListBox.addItem(institution.getLabel());
                    }
                    InstitutionPropertyFilter.this.setInstitution(InstitutionPropertyFilter.this.currentInstitution);
                }

                public void onFailure(Throwable caught) {
                }
            });
        }

        void setInstitution(EIURI institution) {
            this.currentInstitution = institution;
            if (institution != null && this.listInstitutionEntities != null) {
                int i = 1;
                for (EIEntity inst : this.listInstitutionEntities) {
                    if (inst.getURI().equals((Object)institution)) {
                        this.institutionListBox.setSelectedIndex(i);
                        return;
                    }
                    ++i;
                }
            }
            this.institutionListBox.setSelectedIndex(0);
        }

        EIURI getSelectedInstitution() {
            return this.currentInstitution;
        }

        private void executeSearch() {
            SearchRequest newRequest;
            SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
            if (previousRequest != null) {
                newRequest = new SearchRequest(previousRequest.toURLParams());
                newRequest.setStartIndex(0);
            } else {
                newRequest = new SearchRequest();
            }
            newRequest.setInstitution(this.currentInstitution);
            SearchContext.INSTANCE.search(newRequest);
        }
    }

    static class PropertyFilter
    extends VerticalPanel {
        PropertyFilter(String label) {
            this.setStyleName("propertyPanel");
            Label l = new Label(label);
            this.add((Widget)l);
            l.setStyleName("label");
        }
    }

    static class DatatypePropertyInfo {
        EIEntity property;
        String valueDefaultText;

        DatatypePropertyInfo() {
        }
    }
}

