/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.AbstractSearchBox;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.OntologyDropdownBase;
import org.eaglei.suggest.client.SearchSuggestOracle;
import org.eaglei.suggest.client.SearchSuggestion;
import org.eaglei.suggest.client.SelectionListener;

public class TypeChooser<OntologyPicker extends OntologyDropdownBase>
extends Composite {
    private TypeSuggestBox boxType;
    private OntologyPicker ontologyBrowser;

    public TypeChooser(OntologyPicker ontPicker) {
        HorizontalPanel hp = new HorizontalPanel();
        hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.initWidget((Widget)hp);
        this.boxType = new TypeSuggestBox();
        this.boxType.addSearchHandler(new AbstractSearchBox.SearchHandler(){

            public void performSearch(String query, String uri) {
                if (uri == null) {
                    return;
                }
                EIEntity selectedEntity = EIEntity.create((String)uri, (String)query);
                TypeChooser.this.boxType.setSelectedEntity(selectedEntity);
            }
        }, true, true);
        hp.add((Widget)this.boxType);
        this.ontologyBrowser = ontPicker;
        this.ontologyBrowser.addSelectionListener(new SelectionListener(){

            public void onSelection(EIClass resource) {
                TypeChooser.this.boxType.setSelectedEntity(resource.getEntity());
            }
        });
        hp.add(this.ontologyBrowser);
    }

    public void addSelectionListener(EntitySelectionListener listener) {
        this.boxType.addSelectionListener(listener);
    }

    protected String removeTags(String displayString) {
        String result = displayString.replace("<B>", "");
        result = result.replace("</B>", "");
        return result;
    }

    public void setClass(EIClass rClass, boolean readOnly) {
        this.boxType.setClass(rClass);
        if (rClass != null && rClass.hasSubClass()) {
            this.ontologyBrowser.setResource(rClass);
            this.ontologyBrowser.setVisible(true);
        } else {
            this.ontologyBrowser.setVisible(false);
        }
    }

    public EIURI getSelectedURI() {
        return this.boxType.getSelectedEntity() != null ? this.boxType.getSelectedEntity().getURI() : null;
    }

    public void setSelectedEntity(EIEntity selectedEntity) {
        this.boxType.setSelectedEntity(selectedEntity);
    }

    public void setTextBoxStyle(String styleName) {
        this.boxType.setStyleName(styleName);
    }

    public void setEnabled(boolean enabled) {
        this.boxType.setEnabled(enabled);
        this.ontologyBrowser.setVisible(enabled);
    }

    private static class TypeSuggestBox
    extends AbstractSearchBox {
        private EIClass rootClass;
        private EIEntity selectedEntity;
        private ArrayList<EntitySelectionListener> listeners = null;

        public TypeSuggestBox() {
            super((SearchSuggestOracle)new TypeSuggestOracle(), "TypeSearchBox");
            this.sbSearch.getTextBox().addBlurHandler(new BlurHandler(){

                public void onBlur(BlurEvent event) {
                    if (TypeSuggestBox.this.selectedEntity == null && !TypeSuggestBox.this.getDefaultText().equals(TypeSuggestBox.this.sbSearch.getText()) || TypeSuggestBox.this.selectedEntity != null && !TypeSuggestBox.this.selectedEntity.getLabel().equals(TypeSuggestBox.this.sbSearch.getText())) {
                        SearchSuggestion suggestMatch = TypeSuggestBox.this.getSuggestMatch();
                        if (suggestMatch != null) {
                            EIEntity entity = suggestMatch.createEntity();
                            TypeSuggestBox.this.setSelectedEntity(entity);
                        } else {
                            TypeSuggestBox.this.setSelectedEntity(null);
                        }
                    }
                }
            });
        }

        public void setEnabled(boolean enabled) {
            this.sbSearch.getTextBox().setEnabled(enabled);
        }

        public void addSelectionListener(EntitySelectionListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
        }

        public String getDefaultText() {
            return this.rootClass != null ? this.rootClass.getEntity().getLabel() : "All Resource Types";
        }

        public String getSearchBaseURL() {
            assert (false);
            return null;
        }

        public void setClass(EIClass rootClass) {
            this.rootClass = rootClass;
            EIURI uri = rootClass != null ? rootClass.getEntity().getURI() : null;
            ((TypeSuggestOracle)this.sbSearch.getSuggestOracle()).setClassId(uri);
            this.setSelectedEntity(rootClass != null ? rootClass.getEntity() : null);
        }

        public EIEntity getSelectedEntity() {
            return this.selectedEntity;
        }

        public void setSelectedEntity(EIEntity selectedEntity) {
            this.selectedEntity = selectedEntity;
            if (selectedEntity != null) {
                this.setText(selectedEntity.getLabel());
            } else {
                this.setDefaultText();
            }
            if (this.listeners != null) {
                for (EntitySelectionListener listener : this.listeners) {
                    listener.onSelection(selectedEntity);
                }
            }
        }
    }

    private static class TypeSuggestOracle
    extends SearchSuggestOracle {
        private String classId;

        public TypeSuggestOracle() {
            super(GWT.getModuleBaseURL());
        }

        void setClassId(EIURI classId) {
            this.classId = classId == null ? null : URL.encodeComponent((String)classId.toString());
        }

        protected String createURL(String callbackName, int id, String query) {
            String url = super.createURL(callbackName, id, query);
            return this.classId != null ? url + "&classid=" + this.classId : url;
        }
    }
}

