package org.eaglei.ui.gwt.instance;

import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.security.SessionContext;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

public class ContactPanel extends PopupPanel {

    interface MyUiBinder extends UiBinder<Widget, ContactPanel> {
    }

    private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

    @UiField TextBox fromNameText;
    @UiField TextBox fromEmailText;
    @UiField TextBox subjectText;
    @UiField TextArea messageText;
    @UiField CheckBox testMode;
    @UiField Button okButton;
    @UiField Button cancelButton;

    public ContactPanel(final EIInstance instance) {
        setWidget(uiBinder.createAndBindUi(this));
        setStyleName("popup_block");
        
        testMode.setStyleName("testMode");
        testMode.setValue(true);
        
        okButton.addClickHandler(new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                sendMessage(instance.getEntity().getURI(), instance.getEntity().getLabel());
            }
        });
        
        cancelButton.addClickHandler(new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                hide();
            }
        });
    }
    
    private void sendMessage(final EIURI instanceURI, final String instanceLabel) {
        InstancePage.instanceService.contactMessage(SessionContext.getSessionId(), 
                instanceURI, instanceLabel, testMode.getValue(), 
                fromNameText.getText(), fromEmailText.getText(), 
                subjectText.getText(), messageText.getText(), new AsyncCallback<Boolean>() {
                    
                    @Override
                    public void onSuccess(Boolean result) {
                        if (result) {
                            Window.alert("Your message has been sent.");
                            hide();
                        } else {
                            Window.alert("Error sending message.  Please check required fields.");
                        }
                    }
                    
                    @Override
                    public void onFailure(Throwable caught) {
                        Window.alert("Error: " + caught.getMessage());
                    }
                });
    }
}
