package org.eaglei.ui.gwt.instance;

import java.util.HashMap;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

// Note: needs to be here so GWT can find it; if it moves to another package, create a relevant .gwt.xml & refer to it where needed
public class EagleIEntityConstants {

	public static final String EI_LAB = "http://purl.obolibrary.org/obo/ERO_0000001";
	public static final String FOAF_PERSON="http://xmlns.com/foaf/0.1/Person";
	public static final String EI_ORGANIZATION="http://purl.obolibrary.org/obo/OBI_0000245";
	
		
	public static final String EI_LAB_Label = "Laboratory";
	public static final String EI_ORGANIZATION_LABEL = "Organization";
	public static final EIURI EI_LAB_URI = EIURI.create( EI_LAB );
	public static final EIURI FOAF_PERSON_URI=EIURI.create(FOAF_PERSON);
	public static final EIURI EI_ORGANIZATION_URI=EIURI.create(EI_ORGANIZATION);

	public static final String EI_CORE_LAB = "http://purl.obolibrary.org/obo/ERO_0000002";
	public static final EIURI EI_CORE_LAB_URI = EIURI.create( EI_CORE_LAB );
	public static final EIEntity EI_LAB_ENTITY = EIEntity.create( EI_LAB, EI_LAB_Label );
	public static final EIEntity EI_ORGANIZATION_ENTITY = EIEntity.create( EI_ORGANIZATION, EI_ORGANIZATION_LABEL );
	public static final EIEntity RDFS_LABEL_ENTITY = EIEntity.create( EagleIEntityConstants.RDFS_LABEL, "Name" );
	public static final EIEntity RDF_TYPE_ENTITY = EIEntity.create( EagleIEntityConstants.RDF_TYPE, "Type" );
	public static final String RDFS_LABEL = "http://www.w3.org/2000/01/rdf-schema#label";
	public static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
	
	public static final String COMMENTS = "http://eagle-i.org/ont/datatools/1.0/user_comments";
	public static final String COMMENTS_LABEL = "Comments";
	public static final String CURATOR_NOTE = "http://purl.obolibrary.org/obo/IAO_0000232";
	public static final String CURATOR_LABEL = "Curator note";
	public static final EIEntity COMMENTS_ENTITY = EIEntity.create(COMMENTS, COMMENTS_LABEL);
	public static final EIEntity CURATOR_NOTE_ENTITY = EIEntity.create( CURATOR_NOTE, CURATOR_LABEL);
	public static final EIEntity TERM_REQUEST_ENTITY = EIEntity.create( "http://eagle-i.org/ont/datatools/1.0/has_term_request", "Term Request" );
	public static final EIEntity RESOURCE_DESCRIPTION_ENTITY = EIEntity.create("http://eagle-i.org/ont/data/resource_description", "Description");
	public static final EIEntity SYNONYM_ENTITY = EIEntity.create("http://eagle-i.org/ont/data/synonym", "Additional Name");
	
	
	//FIXME temporary place for tooltips on properties that are dataModelExclude, while we figure out how to load the datatools ontology model
	public static final Map<EIEntity, String> missingTooltips = new HashMap<EIEntity, String>() {
		private static final long serialVersionUID = 1L;

		{
			put(TERM_REQUEST_ENTITY, "If you do not see the word or phrase you need, use this field to request that it be added to eagle-i.");
			put(RDFS_LABEL_ENTITY, "Display label that identifies the resource.");
			put(RDF_TYPE_ENTITY, "Identifies the resource category.");
			put(COMMENTS_ENTITY, "Recorded notes about why some fields contain no information, the annotation process, or other.");
			put(CURATOR_NOTE_ENTITY, "Comments entered by Curators. Invisible to Search. Not for annotation purposes.");
		}
		};

}
