package org.eaglei.ui.gwt.instance;

import java.util.List;
import java.util.logging.Logger;

import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.LogoutPanel;
import org.eaglei.ui.gwt.SearchInstancePanel;
import org.eaglei.ui.gwt.ApplicationContext.ApplicationPage;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.SearchSidebarComponent;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;
import org.eaglei.ui.gwt.sidebar.SideBar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class InstancePage extends Composite implements SessionListener, ApplicationPage, InstanceChangeListener {

	private static final String URI_KEY = "uri";
	private static final Logger log = Logger.getLogger( "InstancePage" );

	public static final InstanceServiceRemoteAsync instanceService = GWT.create( InstanceServiceRemote.class );

	private FlowPanel instancePanel;
	private SearchSidebarComponent searchbox;
	private ContactSidebarComponent contact;
	private ReferencedBySidebarComponent references;

	private EIURI instanceID;

	public InstancePage() {
		FlowPanel outer = new FlowPanel();
		initWidget( outer );

		LogoutPanel logoutPanel = new LogoutPanel();
		outer.add( logoutPanel );
		logoutPanel.setStyleName( "searchPageLogoutBox" );

		FlowPanel innerDiv = new FlowPanel();
		innerDiv.setStyleName( "mainPanel" );
		HorizontalPanel mainPanel = new HorizontalPanel();
		SideBar sidebar = new SideBar();
		mainPanel.add( sidebar );
		DOM.setStyleAttribute( DOM.getParent( sidebar.getElement() ), "borderRight", "1px solid #CCC" );
		instancePanel = new FlowPanel();
		instancePanel.setStyleName( "formPanel" );
		mainPanel.add( instancePanel );
		innerDiv.add( mainPanel );
		outer.add( innerDiv );

		contact = new ContactSidebarComponent();
		sidebar.addComponent( contact );
		references = new ReferencedBySidebarComponent();
		sidebar.addComponent( references );
		searchbox = new SearchSidebarComponent();
		sidebar.addComponent( searchbox );

		searchbox.setWidth( "180px" );
		contact.setWidth( "180px" );
		references.setWidth( "180px" );
	}

	@Override
	public Widget asWidget() {
		return this;
	}

	public void setPageParams(String params) {
		log.finer( "setting page to " + params );
		searchbox.setDefaultText();
		references.setReferences( null );

		String[] parts = params.split( "=" );
		if ( parts.length != 2 ) {
			instancePanel.clear();
			instancePanel.add( new Label( "Invalid URL, cannot display resource." ) );
		}

		if ( !parts[0].equals( URI_KEY ) ) {
			instancePanel.clear();
			instancePanel.add( new Label( "Invalid URL, cannot display resource." ) );
		}

		String uriStr = parts[1];
		instanceID = EIURI.create( uriStr );

		if ( SessionContext.getSessionId() == null ) {
			onLogOut();
			return;
		}

		displayContent( this );
	}

	private void displayContent(final InstanceChangeListener listener) {
		instancePanel.clear();
		instancePanel.add( new Image( ApplicationResources.INSTANCE.loading() ) );

		instanceService.getEIInstance( SessionContext.getSessionId(), instanceID, new AsyncCallback<EIInstance>() {

			@Override
			public void onFailure(Throwable caught) {
				instancePanel.clear();
				if ( caught instanceof InvalidSessionIdException ) {
					SessionContext.INSTANCE.logOut();
				} else {
					instancePanel.add( new HTML( caught.getLocalizedMessage() ) );
				}
			}

			@Override
			public void onSuccess(final EIInstance instance) {
				if ( !instance.getInstanceURI().equals( instanceID ) ) {
					// Another request has been made.
					return;
				}
				instanceService.setReferencingResources( SessionContext.getSessionId(), instance, new AsyncCallback<EIInstance>() {
					@Override
					public void onSuccess(EIInstance result) {

						instancePanel.clear();
						// properties
						SearchInstancePanel propertiesPanel = new SearchInstancePanel( result, listener );
						instancePanel.add( propertiesPanel );

						references.setReferences( result.getReferencedByList() );

					}

					@Override
					public void onFailure(Throwable caught) {
						// TODO Auto-generated method stub

					}
				} );

				contact.setInstance( instance );
			}

		} );
	}

	@Override
	public void onLogIn() {
		if ( instanceID != null ) {
			displayContent( this );
		}
	}

	@Override
	public void onLogOut() {
		instancePanel.clear();
		references.setReferences( null );
		instancePanel.add( new Label( "Please login" ) );
	}

	@Override
	public void onInstanceChanged(EIURI instanceUri) {
		setPageParams( "uri=" + instanceUri.toString() );
	}

}
