package org.eaglei.ui.gwt.instance;

import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.ui.gwt.instance.Renderer;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.security.SessionContext;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;

public class MaterializedInversePropRenderer implements Renderer {

	EIInstance eiInstance;
	FlowPanel materializedPropertiesPanel;
	private final InstanceChangeListener listener;
	
	public static final InstanceServiceRemoteAsync instanceService = GWT
    .create(InstanceServiceRemote.class);
	
	public MaterializedInversePropRenderer(EIInstance eiInstance, FlowPanel materializedPropertiesPanel, InstanceChangeListener listener ) {
		this.eiInstance = eiInstance;
		this.materializedPropertiesPanel = materializedPropertiesPanel;
		this.listener = listener;
		renderProperties();
	}

	@Override
	public void renderProperties() {
		drawMaterializedInverseProperties();
	}
	
	private void drawMaterializedInverseProperties() {
//		instanceService.setReferencingResources(SessionContext.getSessionId(), eiInstance, new AsyncCallback<EIInstance>() {
//
//			@Override
//			public void onSuccess(EIInstance result) {
//				Map<EIEntity, List<EIInstanceMinimal>> materializedInverseProperties = result.getMaterializedInverseProperties();
//				
//				for(EIEntity entity:materializedInverseProperties.keySet()) {
//					MaterializedPropertyWidget materializedPropertyWidget = new MaterializedPropertyWidget( result, entity, materializedInverseProperties.get(entity), materializedPropertiesPanel, listener );
//					materializedPropertiesPanel.add(materializedPropertyWidget);
//				}
//			}
//
//			@Override
//			public void onFailure(Throwable caught) {
//				// TODO Auto-generated method stub
//				
//			}
//		});
		
		Map<EIEntity, List<EIInstanceMinimal>> materializedInverseProperties = eiInstance.getMaterializedInverseProperties();
		
		for(EIEntity entity:materializedInverseProperties.keySet()) {
			MaterializedPropertyWidget materializedPropertyWidget = new MaterializedPropertyWidget( eiInstance, entity, materializedInverseProperties.get(entity), materializedPropertiesPanel, listener );
			materializedPropertiesPanel.add(materializedPropertyWidget);
		}
	}

}
