package org.eaglei.ui.gwt.instance;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;

public class MaterializedPropertyWidget extends Composite {
	
	private FlowPanel mainPanel;
	List<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
	DisclosurePanel materializedPanel;
	private final InstanceChangeListener listener;
	private static final Logger log = Logger.getLogger( "SearchOntologyPropViewRenderer" );
	
	public static final InstanceServiceRemoteAsync instanceService = GWT
    .create(InstanceServiceRemote.class);
	
	public MaterializedPropertyWidget(EIInstance eiInstance, EIEntity propertyEntity, List<EIInstanceMinimal> eiInstanceMinimalList, FlowPanel mainPanel, InstanceChangeListener listener) {
		instanceList = eiInstanceMinimalList;
		this.mainPanel = mainPanel;
		materializedPanel = new DisclosurePanel(propertyEntity.getLabel());
		this.listener = listener;
		initWidget( materializedPanel );
		setup();
	}


	private void setup() {
		
		FlowPanel innerPanel = new FlowPanel();
		for(final EIInstanceMinimal eiInstance:instanceList) {
			Anchor a = new Anchor(eiInstance.getInstanceLabel() + " <" + eiInstance.getInstanceType().getLabel() + ">");
			innerPanel.add(a );
			
			a.addClickHandler( new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					mainPanel.clear();
					
					ClientModelManager.INSTANCE.isModelClassURI( eiInstance.getInstanceURI(), new AsyncCallback<Boolean>() {
						@Override
						public void onFailure(Throwable caught) {
							//log.error( "there is async error in org.eaglei.datatools.client.ui.ViewFormsPanel#draObjectProperty when calling isModelClassURI(EIURI) Async method " );
						}

						@Override
						public void onSuccess(Boolean result) {
							// if it is ontology entity then open glossary window otherwise get new instance from repository and show it 
							if ( result ) {
								Window.open( InstanceWidgetUtils.getGlossaryURL() + "#t=" + eiInstance.getInstanceURI().toString(), "", "" );
							}
							else {
								log.fine("listener changing instance to " + eiInstance.getInstanceURI());
								listener.onInstanceChanged( eiInstance.getInstanceURI() );
								//getInstanceByURI( eiInstance.getInstanceURI() );
							}
						}
					} );
					
					
				}
			});
		}
		materializedPanel.setContent( innerPanel);
	}
	
	
//	public void getInstanceByURI(EIURI uri) {
//		instanceService.getEIInstance( SessionContext.getSessionId(), uri, new AsyncCallback<EIInstance>() {
//			
//			@Override
//			public void onSuccess(EIInstance result) {
//				SearchInstancePanel sip = new SearchInstancePanel( result );
//				mainPanel.add( sip );
//			}
//			
//			@Override
//			public void onFailure(Throwable caught) {
//				// TODO Auto-generated method stub
//				
//			}
//		});
//	}

}
