package org.eaglei.ui.gwt.instance;

import static org.eaglei.model.EIOntConstants.PG_CONTACT_LOCATION;
import static org.eaglei.model.EIOntConstants.PG_EMAIL_CONTACT;
import static org.eaglei.model.EIOntConstants.PG_LAB_RELATED;
import static org.eaglei.model.EIOntConstants.PG_PRIMARY;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.EI_ORGANIZATION_LABEL;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.FOAF_PERSON_URI;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.RDFS_LABEL_ENTITY;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.RDF_TYPE_ENTITY;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.RESOURCE_DESCRIPTION_ENTITY;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.SYNONYM_ENTITY;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassesInGroupCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.PropertyCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.PropertyDefinitionCallback;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;

public abstract class OntologyPropertiesRenderer implements Renderer{
	protected EIInstance eiInstance;
	protected EIClass eiClass;
	protected List<EIProperty> eiProperties; // List of fully downloaded properties of the EIClass
	protected Map<EIEntity, EIProperty> eiPropertiesEntityMap = new HashMap<EIEntity, EIProperty>(); // TODO: TOTAL HACK. Get rid of this when we get around to handing around properties instead of all these features of properties
	protected FlowPanel ontologyPanel;
	protected EIClass rootSuperClass;

	public abstract Collection<EIEntity> getDataTypeEntities();

	public abstract Collection<EIEntity> getObjectTypeEntities();

	public abstract void addFormTitle(String type);
	
	public abstract void fetchConstants();
	
	protected abstract void addNameProperty(String labelPrefix);
	
	protected abstract void addTypeProperty(String labelPrefix);

	public OntologyPropertiesRenderer(final EIInstance eiInstance, final FlowPanel ontologyPanel) { 
		this.ontologyPanel = ontologyPanel; 
		ontologyPanel.setStyleName( "formPanelInside" );
//		this.ontologyPanel.addStyleName("clearBoth");
		this.eiInstance = eiInstance;
		this.eiClass = eiInstance.getInstanceClass(); 
		this.rootSuperClass = eiInstance.getRootSuperType();
		initializeProperties();
	}

	public void renderProperties() {
		String labelPrefix;
		if ( rootSuperClass != null ) {
			labelPrefix = rootSuperClass.getEntity().getLabel();
		} else {
			labelPrefix = eiClass.getEntity().getLabel();
		}
		// Name and type go always first
		addFormTitle( labelPrefix );
		addNameProperty( labelPrefix );
		addTypeProperty( labelPrefix );
		final Collection<EIEntity> dataProps = getDataTypeEntities();
		final Collection<EIEntity> objectProps = getObjectTypeEntities();

		final Map<EIEntity, Set<String>> instanceDataTypeProperties = eiInstance.getDatatypeProperties();
		final Map<EIEntity, Set<EIEntity>> instanceObjectProperties = eiInstance.getObjectProperties();

		// Reorder properties
		// FIXME this is worth caching somewhere else (ClientRepositoryToolsManager?)
		final List<EIProperty> reorderedProperties = reorderProperties( labelPrefix, instanceDataTypeProperties );

		for (final EIProperty property : reorderedProperties) { 
			if ( property instanceof EIDatatypeProperty && dataProps.contains( property.getEntity() ) ) {
				drawDataProperty( property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, instanceDataTypeProperties.get( property.getEntity() ) );
			} else if ( property instanceof EIObjectProperty && objectProps.contains( property.getEntity() ) ) {
				drawObjectProperty( property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, instanceObjectProperties.get( property.getEntity() ) );
			}
		}
	}

	/**
	 * rearranges the properties according to property groups, for preferred form display. Currently: - additional name - resource description - lab information - people (based on range of property) - contact information (based on privacy
	 * annotations) - dates (total hack) - primary properties of resource type (based on new annotation) - secondary properties (whatever is left)
	 * 
	 * ORDER IS SUBJECT TO CHANGE TODO specify group order in a config file; specify order within a group
	 * 
	 * @param labelPrefix
	 * @param instanceDataTypeProperties
	 * @return
	 */
	private List<EIProperty> reorderProperties(final String labelPrefix, final Map<EIEntity, Set<String>> instanceDataTypeProperties) {
		final List<EIProperty> personProperties = new ArrayList<EIProperty>();
		final List<EIProperty> contactProperties = new ArrayList<EIProperty>();
		final List<EIProperty> providerProperties = new ArrayList<EIProperty>();
		final List<EIProperty> dateProperties = new ArrayList<EIProperty>();
		final List<EIProperty> primaryProperties = new ArrayList<EIProperty>();
		final List<EIProperty> secondaryProperties = new ArrayList<EIProperty>();
		final Collection<EIEntity> dataprops = getDataTypeEntities();
		for (final EIProperty property : eiProperties) {
			if ( property.getEntity().equals( RESOURCE_DESCRIPTION_ENTITY ) && dataprops.contains( property.getEntity() ) ) {
				final EIEntity newDescriptionEntity = EIEntity.create( RESOURCE_DESCRIPTION_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel( labelPrefix, RESOURCE_DESCRIPTION_ENTITY.getLabel() ) );
				drawDataProperty( newDescriptionEntity, property.getDefinition(), property.getValueRestriction() != null, instanceDataTypeProperties.get( property.getEntity() ) );
				continue;
			}
			if ( property.getEntity().equals( SYNONYM_ENTITY ) && dataprops.contains( property.getEntity() ) ) {
				final EIEntity newSynonymEntity = EIEntity.create( SYNONYM_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel( labelPrefix, SYNONYM_ENTITY.getLabel() ) );
				drawDataProperty( newSynonymEntity, property.getDefinition(), property.getValueRestriction() != null, instanceDataTypeProperties.get( property.getEntity() ) );
				continue;
			}
			if ( hasPersonRange( property ) ) {
				personProperties.add( property );
				continue;
			}

			if ( property.getEntity().getLabel().contains( "date" ) ) {
				dateProperties.add( property );
				continue;
			}

			final Set<String> annotations = property.getAnnotations();
			if ( annotations.contains( PG_LAB_RELATED ) ) {
				providerProperties.add( property );
				continue;
			}
			if ( annotations.contains( PG_CONTACT_LOCATION ) || annotations.contains( PG_EMAIL_CONTACT ) ) {
				contactProperties.add( property );
				continue;
			}

			if ( annotations.contains( PG_PRIMARY ) ) {
				primaryProperties.add( property );
				continue;
			}
			secondaryProperties.add( property );
		}

		final List<EIProperty> reorderedProperties = new ArrayList<EIProperty>();
		reorderedProperties.addAll( providerProperties );
		reorderedProperties.addAll( personProperties );
		reorderedProperties.addAll( contactProperties );
		Collections.reverse( dateProperties );
		reorderedProperties.addAll( dateProperties );
		reorderedProperties.addAll( primaryProperties );
		reorderedProperties.addAll( secondaryProperties );
		return reorderedProperties;
	}

	private boolean hasPersonRange(final EIProperty property) {
		if ( !( property instanceof EIObjectProperty ) ) {
			return false;
		}
		final List<EIClass> ranges = ( (EIObjectProperty)property ).getRangeList();
		if ( ranges.size() == 1 && ranges.get( 0 ).getEntity().getURI().equals( FOAF_PERSON_URI ) ) {
			return true;
		} else {
			return false;
		}
	}

	protected HashSet<String> makeSetFromSingle(final String value) {
		return new HashSet<String>( Arrays.asList( new String[] { value } ) );
	}

	protected HashSet<EIURI> makeSetFromSingleURI(final EIURI value) {
		return new HashSet<EIURI>( Arrays.asList( new EIURI[] { value } ) );
	}

	protected HashSet<EIEntity> makeSetFromSingleEntity(final EIEntity value) {
		return new HashSet<EIEntity>( Arrays.asList( new EIEntity[] { value } ) );
	}  

	protected abstract void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues);

	protected abstract void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues);

	protected void initializeProperties() { 
		ClientModelManager.INSTANCE.getProperties( eiClass, new PropertyCallback() {
			@Override
			public void onSuccess(final EIClass result) {
				ClientModelManager.INSTANCE.getPropertyDefinitions( result.getProperties(), new PropertyDefinitionCallback() {
					@Override
					public void onSuccess(final List<EIProperty> properties) {
						eiProperties = properties; 
						for (final EIProperty property : eiProperties) {
							eiPropertiesEntityMap.put( property.getEntity(), property );
						}
						fetchConstants();
					}
				} );
			}
		} );
	}

	/*
	 * protected void setRootSuperClass() { try { ClientModelManager.INSTANCE.getRootSuperClass(eiClass, new ClassCallback() {
	 * 
	 * @Override public void onSuccess(final EIClass result) { rootSuperClass = result; //finishSetup(); fetchConstants(); } });
	 * 
	 * } catch (LoggedException e) { // TODO: what to do here? }
	 * 
	 * }
	 */

	
	protected void finishSetup() { 
		renderProperties();
	}

}
