package org.eaglei.ui.gwt.instance.rpc;


import java.util.List;

import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIInstanceX;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("instance")
public interface InstanceServiceRemote extends RemoteService {
	public EIInstanceX getInstance(final String sessionID, final EIURI instanceID) throws InvalidSessionIdException, LoggedException;
	
	public boolean contactMessage(String sessionID, EIURI instanceID, String label, boolean test_mode, 
	        String from_name, String from_email, String subject, String message) throws InvalidSessionIdException, LoggedException;
	
	public EIInstance setReferencingResources(String sessionID, EIInstance instance) throws Exception;

	public EIInstance getEIInstance(String sessionID, final EIURI instanceID) throws Exception;
	
	public List<EIInstanceMinimal> listReferencingResources(String sessionID, String userURI, EIURI resourceUri, AuthSearchRequest queryRequest, boolean strictOwnerFilter) throws Exception;
}
