package org.eaglei.ui.gwt.instance.server;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIInstanceX;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.security.SecurityProvider;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryInstanceProvider;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * Implementation of InstanceService.
 */
public class InstanceServlet extends RemoteServiceServlet implements InstanceServiceRemote {

	private static final long serialVersionUID = 1L;
	private static final Log logger = LogFactory.getLog(InstanceServlet.class);    
    private RepositoryInstanceProvider instanceProvider;
    private SecurityProvider securityProvider;
    protected static final String READ_VIEW = "user";
    
    private static EIOntModel ontModel;

    public InstanceServlet() {
    }

    @Override
    public void init() {
        WebApplicationContext ctx = 
            WebApplicationContextUtils.getWebApplicationContext(getServletContext());
        instanceProvider = ctx.getBean(RepositoryInstanceProvider.class);
        securityProvider = ctx.getBean("securityProvider", SecurityProvider.class);
        ontModel = ctx.getBean( EIOntModel.class );
    }

    @Override
    public void destroy() {
    }
    
	/* (non-Javadoc)
	 * @see org.eaglei.services.repository.InstanceProvider#getInstance(org.eaglei.security.Session, org.eaglei.model.EIURI)
	 */

    public EIInstanceX getInstance(String sessionID, EIURI instanceID) throws InvalidSessionIdException, LoggedException {
        if (!securityProvider.isValid(sessionID)) {
            throw new InvalidSessionIdException();
        }
    	try {
    		return instanceProvider.getInstance(sessionID, instanceID);

    	} catch (Throwable t) {
    		logger.error("Error getting instance", t);
    		throw new LoggedException(t.getLocalizedMessage());
    	}     
    }
    
    public EIInstance getEIInstance(String sessionID, EIURI instanceID) throws InvalidSessionIdException, LoggedException {
    	if(!securityProvider.isValid( sessionID )) {
    		throw new InvalidSessionIdException( );
    	}
    	try {
    		return instanceProvider.getEIInstance( sessionID, instanceID );
    	} catch (Throwable t) {
    		logger.error("Error getting instance", t);
    		throw new LoggedException(t.getLocalizedMessage());
    	}   
    }
    
    public boolean contactMessage(String sessionID, EIURI instanceID, String label, boolean test_mode, 
            String from_name, String from_email, String subject, String message) throws InvalidSessionIdException, LoggedException {
        if (!securityProvider.isValid(sessionID)) {
            throw new InvalidSessionIdException();
        }
        try {
            String client_ip = getThreadLocalRequest().getLocalAddr();
            return instanceProvider.contactMessage(sessionID, client_ip, instanceID, label, test_mode, from_name, from_email, subject, message);
        } catch (Throwable t) {
            logger.error("Error sending contact message", t);
            throw new LoggedException(t.getLocalizedMessage());
        }     
    }
    
    
    public EIInstance setReferencingResources(String sessionId, EIInstance instance) throws Exception {
    	 if (!securityProvider.isValid(sessionId)) {
             throw new InvalidSessionIdException();
         }
    	 
    	 try {
    		return  instanceProvider.setReferencingResources( sessionId, instance );
    	 } catch(Throwable t) {
    		 logger.error("Error setting Referencing resources", t);
             throw new LoggedException(t.getLocalizedMessage());
    	 }
    }

	@Override
	public List<EIInstanceMinimal> listReferencingResources(String sessionID, String userURI, EIURI resourceUri, AuthSearchRequest queryRequest, boolean strictOwnerFilter) throws Exception {
		if (!securityProvider.isValid(sessionID)) {
            throw new InvalidSessionIdException();
        }
		
		try {
			return instanceProvider.listReferencingResources( sessionID, userURI, resourceUri, queryRequest, strictOwnerFilter );

		} catch(Throwable t) {
			 logger.error("Error listing Referencing resources", t);
             throw new LoggedException(t.getLocalizedMessage());
		}
	}
    

}
