package org.eaglei.ui.gwt.instance.widgets;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.*;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;

public class InstanceWidgetUtils {

	/**
	 * 
	 * @param propertyEntity
	 * @return
	 */
	/*
	 * public static Label createLabel(EIEntity propertyEntity) { return createLabel(propertyEntity.getLabel(), ""); }
	 * 
	 * public static Label createLabel(String label) { return createLabel(label, ""); }
	 */
	
	public static Label createLabel(final EIEntity propertyEntity, final String definition, final boolean isRequired) {
		if ( propertyEntity == null || propertyEntity == EIEntity.NULL_ENTITY ) {
			return InstanceWidgetUtils.createLabel( "", definition, isRequired );
		}
		if( missingTooltips.containsKey(propertyEntity) ) {
			return InstanceWidgetUtils.createLabel( propertyEntity.getLabel(), missingTooltips.get(propertyEntity), isRequired );
		}
		return InstanceWidgetUtils.createLabel( propertyEntity.getLabel(), definition, isRequired );
	}
	
	// FIXME see if this doesn't screw up other capitalization
	public static Label createLabel(final String label, final String definition, final boolean isRequired) {
		Label propertyLabel;
		if ( label == null || "".equals( label ) ) {
			propertyLabel = new Label( label );
		} else {
			propertyLabel = new Label( capitalizeFirst( label ) );
		}

		if ( isRequired ) {
			propertyLabel.setStyleName( "formLabelRequired" );
		} else {
			propertyLabel.setStyleName( "formLabel" );
		}

		if ( definition != null && !"".equals( definition ) && !"NO DEFINITION".equals( definition ) ) {
			propertyLabel.setTitle( definition );
		}
		return propertyLabel;
	}
	
	/* utilites for url making for search,glossary and help links */
	public static String getGlossaryURL() {
		final String url = GWT.getHostPageBaseURL();
		final String node = getNodeNameFromURL();
		if ( node != null ) {
			final String searchUrl = url.replace( node + ".", "search." ).replace( "/datatools/", "" ) + "/model/";
			return searchUrl;
		} else {
			return null;
		}
	}
	
	public static String getNodeNameFromURL() {
		final String url = GWT.getHostPageBaseURL();
		int startIndex = -1;
		final int endIndex = url.indexOf( ".eagle-i.net" );
		if ( url.indexOf( "." ) > 0 && url.indexOf( "." ) < endIndex ) {
			startIndex = url.indexOf( "." ) + 1;
		} else {
			startIndex = url.indexOf( "//" ) + 2;
		}
		if ( endIndex == -1 || startIndex == -1 ) {
			return null;
		} else {
			final String node = url.substring( startIndex, endIndex );
			return node;
		}
	}

	
	public static String capitalizeFirst(final String original) {
		final char first = original.charAt( 0 );
		return Character.toUpperCase( first ) + original.substring( 1 );
	}

	/**
	 * Some field values that are retrieved from the repo have extra bit of data attached. This method eliminates the unwanted data in the value.
	 * 
	 * @return formatted value String
	 */
	public static String formatText(final String value) {
		if ( value.indexOf( "^" ) > 0 ) {
			return value.substring( 0, value.indexOf( "^" ) );
		}
		return value;
	}
	
	public static String getExtendedPropertyLabel(final String typeLabel, final String propertyName) {
		// return capitalizeFirst(typeLabel) + " " + lowerCaseFirst(propertyName);
		// Title case is now preferred; the propertyName should be in capital case in the ontology
		return capitalizeFirst( typeLabel ) + " " + propertyName;
	}

	public static String insertBreaks(String value) {
		return value.replaceAll( "(\r\n|\r|\n|\n\r)", "<br/>" );
	}

}
