package org.eaglei.ui.gwt.instance.widgets;

import org.eaglei.model.EIEntity;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class LabelValuesWidget extends Composite {
	FlowPanel labelValuePanel = new FlowPanel();
	FlowPanel valuesPanel = new FlowPanel();

	public LabelValuesWidget(final EIEntity propertyEntity, final String definition, final boolean isRequired) {
		labelValuePanel.setStyleName("ViewRow");
		initWidget( labelValuePanel );
		final Label propLabel = InstanceWidgetUtils.createLabel( propertyEntity, definition, isRequired );
		labelValuePanel.add( propLabel );
		valuesPanel.setStyleName( "ViewRowValueContainer" );
		labelValuePanel.add( valuesPanel );
	}

	// for non-ontology prop
	public LabelValuesWidget(final String propertyLabel) {
		labelValuePanel.setStyleName("ViewRow");
		initWidget( labelValuePanel );
		final Label propLabel = InstanceWidgetUtils.createLabel( propertyLabel, "", false );
		labelValuePanel.add( propLabel );
		valuesPanel.setStyleName( "ViewRowValueContainer" );
		labelValuePanel.add( valuesPanel );
	}

	public void add(final Widget widget) {
		widget.setStylePrimaryName("ViewRowValue");
		valuesPanel.add( widget );
	}
}
