package org.eaglei.ui.gwt.search;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.suggest.DataSuggestBox;
import org.eaglei.ui.gwt.suggest.DataSuggestOracle;
import org.eaglei.ui.gwt.suggest.AbstractSearchBox.SearchHandler;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class DataSuggestSearchBar extends Composite implements SearchContext.SearchListener {

    DataSuggestBox termBox;
    Image searchButton;

    public DataSuggestSearchBar() {
    	this(true);
    }

    public DataSuggestSearchBar(boolean hasResourceSelect) {
        FlowPanel outer = new FlowPanel();
        initWidget(outer);
        
        DataSuggestOracle suggestOracle = new DataSuggestOracle();
        termBox = new DataSuggestBox(suggestOracle);
        outer.add(termBox);
        termBox.addStyleName("searchBoxResults");
        
        searchButton = new Image("images/button-search3.png");
        searchButton.setSize("130px", "38px");
        outer.add(searchButton);
        searchButton.setStyleName("buttonPadding");

    	//outer.add(searchButton);
        searchButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                String query = termBox.getText();
                executeSearch(query, null);
            }
        });

        termBox.addSearchHandler(new SearchHandler() {

            @Override
            public void performSearch(String query, String uri) {
                executeSearch(query, uri);
            }
            
        }, true, true);
        
        termBox.setDefaultText();
        
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        
        SearchContext.INSTANCE.addListener(this);
        
    }
    
    private void executeSearch(String query, String uri) {
        SearchRequest.Term term;
        if (query.length() == 0 && uri == null) {
            term = null;
        } else {
            term = new SearchRequest.Term(query, (uri != null ? EIURI.create(uri) : null));
        }
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        SearchRequest newRequest;
        if (previousRequest != null) {
            // TODO: somewhat inefficient way to create a clone
            newRequest = new SearchRequest(previousRequest.toURLParams());
            newRequest.setStartIndex(0);
        } else {
            newRequest = new SearchRequest();
        }
        newRequest.setTerm(term);
        SearchContext.INSTANCE.search(newRequest);
    }
    
    public void sizeToParent(int maxWidth) {
        int termBoxWidth = maxWidth - 130;  // search button

        termBox.setWidth(termBoxWidth + "px");        
    }
    
    private void setSearchRequest(SearchRequest request) {
        if (request != null && request.getTerm() != null) {
            termBox.setText(request.getTerm().getQuery());
        } else {
            termBox.setDefaultText();
        }
    }
    
    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (request == null) {
            return;
        }
        
        if (!isAttached()) {
            return;
        }
         
        // A UI component in the interface has initiated a search.
        // Write the current term box content into the SearchRequest before it is executed.
        String query = termBox.getText();
        // TODO check for URI in the SearchRequest
        if (request.getTerm() == null || request.getTerm().getQuery().length() == 0) {
            if (query.length() > 0) {
                request.setTerm(new SearchRequest.Term(query));
            }
        } else if (request.getTerm() != null && request.getTerm().getQuery().length() > 0) {
            if (!request.getTerm().getQuery().equals(query)) {
                if (query.length() > 0) {
                    request.setTerm(new SearchRequest.Term(query));
                } else {
                    request.setTerm(null);
                }
            }
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        setSearchRequest(request);
    }
    
    @Override
    public void onResults(ClientSearchResultSet results) {
    }
    
}
