package org.eaglei.ui.gwt.search;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.suggest.client.AbstractSearchBox.SearchHandler;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class SearchBar extends Composite implements SearchContext.SearchListener {

    interface MyUiBinder extends UiBinder<Widget, SearchBar> {
    }

    private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);
    
    @UiField
    TermSuggestBox termBox;
    @UiField
    Image searchButton;

    public SearchBar() {
    	this(true);
    }

    public SearchBar(boolean hasResourceSelect) {
        initWidget(uiBinder.createAndBindUi(this));

    	//outer.add(searchButton);
        searchButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                String query = termBox.getText();
                executeSearch(query, null);
            }
        });

        termBox.addSearchHandler(new SearchHandler() {

            @Override
            public void performSearch(String query, String uri) {
                executeSearch(query, uri);
            }
            
        }, true, true);
        
        termBox.setDefaultText();
        
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        
        SearchContext.INSTANCE.addListener(this);
        
    }
    
    private void executeSearch(String query, String uri) {
        SearchRequest.Term term;
        if (query.length() == 0 && uri == null) {
            term = null;
        } else {
            term = new SearchRequest.Term(query, (uri != null ? EIURI.create(uri) : null));
        }
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        SearchRequest newRequest;
        if (previousRequest != null) {
            // TODO: somewhat inefficient way to create a clone
            newRequest = new SearchRequest(previousRequest.toURLParams());
            newRequest.setStartIndex(0);
        } else {
            newRequest = new SearchRequest();
        }
        newRequest.setTerm(term);
        SearchContext.INSTANCE.search(newRequest);
    }
    
    public void sizeToParent(int maxWidth) {
        int termBoxWidth = maxWidth - 130;  // search button

        termBox.setWidth(termBoxWidth + "px");        
    }
    
    private void setSearchRequest(SearchRequest request) {
        if (request != null && request.getTerm() != null) {
            termBox.setText(request.getTerm().getQuery());
        } else {
            termBox.setDefaultText();
        }
    }
    
    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (request == null) {
            return;
        }
        
        if (!isAttached()) {
            return;
        }
         
        // A UI component in the interface has initiated a search.
        // Write the current term box content into the SearchRequest before it is executed.
        String query = termBox.getText();
        // TODO check for URI in the SearchRequest
        if (request.getTerm() == null || request.getTerm().getQuery().length() == 0) {
            if (query.length() > 0) {
                request.setTerm(new SearchRequest.Term(query));
            }
        } else if (request.getTerm() != null && request.getTerm().getQuery().length() > 0) {
            if (!request.getTerm().getQuery().equals(query)) {
                if (query.length() > 0) {
                    request.setTerm(new SearchRequest.Term(query));
                } else {
                    request.setTerm(null);
                }
            }
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        setSearchRequest(request);
    }
    
    @Override
    public void onResults(ClientSearchResultSet results) {
    }
    
}
